/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools.Behavior;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.MeasureEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.EllipseListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;

public class EllipseBehavior
extends Behavior {
    protected List<Double> arrayX = new ArrayList<Double>();
    protected List<Double> arrayY = new ArrayList<Double>();
    protected boolean isClicked = false;
    protected EllipseListener listener;
    private Point2D m_FirstPoint;
    private Point2D m_SecondPoint;
    private Point2D m_ThirdPoint;

    public EllipseBehavior(EllipseListener mli) {
        super(1);
        this.listener = mli;
    }

    @Override
    public void paintComponent(MapControlDrawer mapControlDrawer) {
        mapControlDrawer.setColor(Color.black);
        if (this.arrayX.size() == 1) {
            this.drawCircle(mapControlDrawer);
        } else if (this.arrayX.size() > 1) {
            this.drawEllipseLine(mapControlDrawer);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) throws BehaviorException {
        if (this.isMyButton(e)) {
            if (this.arrayX.isEmpty()) {
                Point2D point = this.getMapControl().getViewPort().toMapPoint((Point2D)e.getPoint());
                this.addPoint(point);
                this.m_FirstPoint = point;
            } else if (this.arrayX.size() == 1) {
                Point2D point = this.getMapControl().getViewPort().toMapPoint((Point2D)e.getPoint());
                if (!point.equals(this.m_FirstPoint)) {
                    this.addPoint(point);
                    this.m_SecondPoint = point;
                }
            } else {
                Point2D point = this.getMapControl().getViewPort().toMapPoint((Point2D)e.getPoint());
                if (!point.equals(this.m_SecondPoint)) {
                    this.addPoint(point);
                    this.m_ThirdPoint = point;
                }
                MeasureEvent event = new MeasureEvent(this.arrayX.toArray(new Double[this.arrayX.size()]), this.arrayY.toArray(new Double[this.arrayY.size()]), e);
                this.listener.ellipseFinished(event);
                this.arrayX.clear();
                this.arrayY.clear();
                this.m_FirstPoint = null;
                this.m_SecondPoint = null;
                this.m_ThirdPoint = null;
                this.isClicked = false;
                this.getMapControl().repaint();
                return;
            }
            this.isClicked = true;
            this.getMapControl().repaint();
            if (this.listener.cancelDrawing()) {
                this.getMapControl().cancelDrawing();
                this.isClicked = false;
                this.getMapControl().repaint();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
        this.mouseMoved(e);
    }

    protected void changeLastPoint(Point2D p) {
        if (this.arrayX.size() > 0) {
            this.arrayX.set(this.arrayX.size() - 1, p.getX());
            this.arrayY.set(this.arrayY.size() - 1, p.getY());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) throws BehaviorException {
        if (this.isClicked) {
            if (this.arrayX.size() == 1) {
                Point2D point;
                this.m_SecondPoint = point = this.getMapControl().getViewPort().toMapPoint((Point2D)e.getPoint());
                ViewPort vp = this.getMapControl().getMapContext().getViewPort();
                Double[] x = new Double[2];
                Double[] y = new Double[2];
                x[0] = this.m_FirstPoint.getX();
                x[1] = this.m_SecondPoint.getX();
                y[0] = this.m_FirstPoint.getY();
                y[1] = this.m_SecondPoint.getY();
                MeasureEvent event = new MeasureEvent(x, y, e);
                this.listener.circle(event);
            } else if (this.arrayX.size() == 2) {
                Point2D point;
                this.m_ThirdPoint = point = this.getMapControl().getViewPort().toMapPoint((Point2D)e.getPoint());
                ViewPort vp = this.getMapControl().getMapContext().getViewPort();
                Double[] x = new Double[3];
                Double[] y = new Double[3];
                x[0] = this.m_FirstPoint.getX();
                x[1] = this.m_SecondPoint.getX();
                x[2] = this.m_ThirdPoint.getX();
                y[0] = this.m_FirstPoint.getY();
                y[1] = this.m_SecondPoint.getY();
                y[2] = this.m_ThirdPoint.getY();
                MeasureEvent event = new MeasureEvent(x, y, e);
                this.listener.ellipse(event);
            }
            this.getMapControl().repaint();
        }
    }

    protected void drawEllipseLine(MapControlDrawer mapControlDrawer) {
        mapControlDrawer.setColor(Color.black);
        if (this.m_FirstPoint != null && this.m_SecondPoint != null && this.m_ThirdPoint != null) {
            ViewPort vp = this.getMapControl().getMapContext().getViewPort();
            Point2D p1 = this.m_FirstPoint;
            Point2D p2 = this.m_SecondPoint;
            Point2D p3 = this.m_ThirdPoint;
            double radio = p2.distance(p3);
            if (radio > 0.0) {
                MultiLine ellipse = null;
                try {
                    ellipse = this.createEllipse(p1, p2, p3).toLines();
                }
                catch (Exception ex) {
                    LOG.warn("Can't create ellipse", (Throwable)ex);
                }
                if (ellipse != null) {
                    mapControlDrawer.draw((Geometry)ellipse);
                }
            }
        }
    }

    protected void drawCircle(MapControlDrawer mapControlDrawer) {
        mapControlDrawer.setColor(Color.black);
        if (this.m_FirstPoint != null && this.m_SecondPoint != null) {
            ViewPort vp = this.getMapControl().getMapContext().getViewPort();
            Point2D p1 = this.m_FirstPoint;
            Point2D p2 = this.m_SecondPoint;
            double radio = p1.distance(p2) / 2.0;
            if (radio > 0.0) {
                Arc arc = null;
                arc = this.createArc((p1.getX() + p2.getX()) / 2.0, (p1.getY() + p2.getY()) / 2.0, radio, 0.0, Math.PI * 2);
                if (arc != null) {
                    mapControlDrawer.draw((Geometry)arc);
                }
            }
        }
    }

    protected void addPoint(Point2D p) {
        this.arrayX.add(p.getX());
        this.arrayY.add(p.getY());
    }

    public void setListener(ToolListener listener) {
        this.listener = (EllipseListener)listener;
    }

    @Override
    public ToolListener getListener() {
        return this.listener;
    }
}

