/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools.Behavior;

import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontrol.tools.Behavior.LineGeometry;

public class LineGeometryImpl
implements LineGeometry {
    private double x0;
    private double x1;
    private double y0;
    private double y1;

    public LineGeometryImpl(double x0, double y0, double x1, double y1) {
        this.x0 = x0;
        this.x1 = x1;
        this.y0 = y0;
        this.y1 = y1;
    }

    public LineGeometryImpl(Point p0, Point p1) {
        this.x0 = p0.getX();
        this.x1 = p1.getX();
        this.y0 = p0.getY();
        this.y1 = p1.getY();
    }

    @Override
    public double angleWithGradient(double gradient) {
        double m1 = this.getGradient();
        double m2 = gradient;
        double toTan = (m2 - m1) / (1.0 + m1 * m2);
        double angle = Math.atan(toTan);
        return Math.toDegrees(angle);
    }

    @Override
    public double angleWith(LineGeometry lineToGetAngle, Point cuadrant) {
        double angle1 = Math.atan2(this.y0 - this.y1, this.x0 - this.x1);
        double angle2 = Math.atan2(lineToGetAngle.getY0() - lineToGetAngle.getY1(), lineToGetAngle.getX0() - lineToGetAngle.getX1());
        double actualAngle = (Math.toDegrees(angle2 - angle1) + 360.0) % 360.0;
        return actualAngle;
    }

    @Override
    public double angleWith(LineGeometry lineToGetAngle) {
        return this.angleWith(lineToGetAngle, null);
    }

    @Override
    public double getGradient() {
        double gradient = (this.y1 - this.y0) / (this.x1 - this.x0);
        return gradient;
    }

    @Override
    public double getIntercept() {
        return this.y0 - this.getGradient() * this.x0;
    }

    @Override
    public double getX0() {
        return this.x0;
    }

    @Override
    public double getY0() {
        return this.y0;
    }

    @Override
    public double getX1() {
        return this.x1;
    }

    @Override
    public double getY1() {
        return this.y1;
    }
}

