/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools.Behavior;

import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;

public class MouseWheelBehavior
extends Behavior {
    @Override
    public ToolListener getListener() {
        return null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) throws BehaviorException {
        MapControl control = this.getMapControl();
        control.cancelDrawing();
        super.mouseWheelMoved(event);
        ViewPort viewPort = control.getViewPort();
        Envelope envelope = viewPort.getEnvelope();
        if (envelope != null) {
            double factor = event.getWheelRotation() < 0 ? 0.75 : 1.3333;
            Point mousePosition = viewPort.convertToMapPoint((Point2D)event.getPoint());
            Point envelopPoint1 = envelope.getLowerCorner();
            Point envelopPoint2 = envelope.getUpperCorner();
            double width1 = mousePosition.getX() - envelopPoint1.getX();
            double heigth1 = mousePosition.getY() - envelopPoint1.getY();
            double width2 = envelopPoint2.getX() - mousePosition.getX();
            double heigth2 = envelopPoint2.getY() - mousePosition.getY();
            double xmin = mousePosition.getX() - width1 * factor;
            double ymin = mousePosition.getY() - heigth1 * factor;
            double xmax = mousePosition.getX() + width2 * factor;
            double ymax = mousePosition.getY() + heigth2 * factor;
            try {
                viewPort.setEnvelope(this.geomManager.createEnvelope(xmin, ymin, xmax, ymax, 0));
            }
            catch (CreateEnvelopeException e) {
                throw new BehaviorException("Error changing the viewport envelope to (" + xmin + "," + ymin + "),(" + xmax + "," + ymax + ")", e);
            }
            this.getMapControl().drawMap(false);
        }
        event.consume();
    }

    @Override
    public void paintComponent(MapControlDrawer mapControlDrawer) {
    }
}

