/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools.Behavior;

import java.awt.AlphaComposite;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.MoveEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveBehavior
extends Behavior {
    private static final Logger logger = LoggerFactory.getLogger(MoveBehavior.class);
    protected Point2D m_FirstPoint;
    protected Point2D m_LastPoint;
    private PanListener listener;

    public MoveBehavior(PanListener pli, int mouseButton) {
        super(mouseButton);
        this.listener = pli;
    }

    public MoveBehavior(PanListener pli) {
        this(pli, 1);
    }

    @Override
    public void paintComponent(MapControlDrawer renderer) {
        if (!this.isMyButton()) {
            return;
        }
        super.paintComponent(renderer);
        BufferedImage image = this.getMapControl().getImage();
        if (image != null && this.m_FirstPoint != null && this.m_LastPoint != null) {
            renderer.setComposite(AlphaComposite.getInstance(3, 0.5f));
            renderer.drawImage(image, (int)(this.m_LastPoint.getX() - this.m_FirstPoint.getX()), (int)(this.m_LastPoint.getY() - this.m_FirstPoint.getY()));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isMyButton(e)) {
            this.m_FirstPoint = e.getPoint();
            if (this.listener.cancelDrawing()) {
                this.getMapControl().cancelDrawing();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        if (this.isMyButton(e) && this.m_FirstPoint != null) {
            this.doMouseReleased(e);
            this.resetMyButton();
        }
    }

    protected void doMouseReleased(MouseEvent e) throws BehaviorException {
        MoveEvent event = new MoveEvent(this.m_FirstPoint, e.getPoint(), e);
        this.listener.move(event);
        this.getMapControl().drawMap(false);
        this.m_FirstPoint = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.isMyButton(e)) {
            this.m_LastPoint = e.getPoint();
            this.getMapControl().repaint();
        }
    }

    public void setListener(ToolListener listener) {
        this.listener = (PanListener)listener;
    }

    @Override
    public ToolListener getListener() {
        return this.listener;
    }
}

