/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools;

import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.fmap.IconThemeHelper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.PointSelectionListenerUniqueSelectPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.UnmodifiableBasicList64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointSelectionListener
implements PointListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PointSelectionListener.class);
    public static int PIXEL_TOLERANCE_FOR_QUERY_BY_POINT = 3;
    protected MapControl mapCtrl;
    private PointSelectionListenerUniqueSelectPanel panel;
    private Geometry selectedGeom = null;

    public PointSelectionListener(MapControl mc) {
        this.mapCtrl = mc;
    }

    List<Pair<FLyrVect, UnmodifiableBasicList64<Feature>>> getClickedFeatures(Point mapPoint) throws BehaviorException {
        FLayer[] actives;
        ArrayList<Pair<FLyrVect, UnmodifiableBasicList64<Feature>>> clickedFeatures = new ArrayList<Pair<FLyrVect, UnmodifiableBasicList64<Feature>>>();
        double tol = this.mapCtrl.getViewPort().toMapDistance(PIXEL_TOLERANCE_FOR_QUERY_BY_POINT);
        for (FLayer active : actives = this.mapCtrl.getMapContext().getLayers().getActives()) {
            if (!(active instanceof FLyrVect)) continue;
            FLyrVect lyrVect = (FLyrVect)active;
            try {
                FeatureStore store = lyrVect.getFeatureStore();
                FeatureQuery query = lyrVect.createQueryByPoint(mapPoint.getX(), mapPoint.getY(), tol, store.getDefaultFeatureType());
                UnmodifiableBasicList64 features = (UnmodifiableBasicList64)store.getFeatures(query);
                if (features.isEmpty()) continue;
                ImmutablePair pair = new ImmutablePair((Object)lyrVect, (Object)features);
                clickedFeatures.add((Pair<FLyrVect, UnmodifiableBasicList64<Feature>>)pair);
            }
            catch (DataException e) {
                throw new BehaviorException("No se pudo hacer la selecci\u00f3n", e);
            }
        }
        return clickedFeatures;
    }

    @Override
    public void point(PointEvent event) throws BehaviorException {
        try {
            FLayer[] actives;
            if (this.panel != null && this.panel.isVisible()) {
                PointSelectionListenerUniqueSelectPanel myPanel = this.panel;
                this.panel = null;
                myPanel.setVisible(false);
            }
            Point mapPoint = event.getMapPoint();
            List<Pair<FLyrVect, UnmodifiableBasicList64<Feature>>> clickedFeatures = this.getClickedFeatures(mapPoint);
            int countFeatures = 0;
            this.selectedGeom = null;
            for (Pair<FLyrVect, UnmodifiableBasicList64<Feature>> pair : clickedFeatures) {
                UnmodifiableBasicList64 unmodifiableBasicList64 = (UnmodifiableBasicList64)pair.getRight();
                long sz = unmodifiableBasicList64.size64();
                if ((countFeatures = (int)((long)countFeatures + sz)) != 1 || sz != 1L) continue;
                this.selectedGeom = ((Feature)unmodifiableBasicList64.get64(0L)).getDefaultGeometry();
            }
            if (countFeatures != 1) {
                this.selectedGeom = null;
            }
            if (event.getEvent().isShiftDown() && countFeatures > 1) {
                if (!event.getEvent().isControlDown()) {
                    for (FLayer active : actives = this.mapCtrl.getMapContext().getLayers().getActives()) {
                        if (!(active instanceof FLyrVect)) continue;
                        FLyrVect lyrVect = (FLyrVect)active;
                        FeatureStore store = lyrVect.getFeatureStore();
                        store.getFeatureSelection().deselectAll();
                    }
                }
                this.panel = new PointSelectionListenerUniqueSelectPanel(this.mapCtrl, event.getEvent().isControlDown());
                this.panel.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        if (e.getSource() == PointSelectionListener.this.panel) {
                            PointSelectionListener.this.panel = null;
                        }
                    }
                });
                WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
                I18nManager i18nManager = ToolsLocator.getI18nManager();
                this.panel.put(clickedFeatures);
                winManager.showWindow(this.panel.asJComponent(), i18nManager.getTranslation("_Features_selector"), WindowManager.MODE.TOOL);
            } else if (event.getEvent().isControlDown()) {
                for (Pair<FLyrVect, UnmodifiableBasicList64<Feature>> pair : clickedFeatures) {
                    FLyrVect fLyrVect = (FLyrVect)pair.getLeft();
                    FeatureStore store = fLyrVect.getFeatureStore();
                    FeatureSelection selection = store.getFeatureSelection();
                    UnmodifiableBasicList64 features = (UnmodifiableBasicList64)pair.getRight();
                    for (Feature feature : features) {
                        if (selection.isSelected(feature)) {
                            selection.deselect(feature);
                            continue;
                        }
                        selection.select(feature);
                    }
                }
            } else {
                for (FLayer active : actives = this.mapCtrl.getMapContext().getLayers().getActives()) {
                    if (!(active instanceof FLyrVect)) continue;
                    FLyrVect lyrVect = (FLyrVect)active;
                    FeatureStore store = lyrVect.getFeatureStore();
                    FeatureSelection selection = store.getFeatureSelection();
                    selection.deselectAll();
                }
                for (Pair<FLyrVect, UnmodifiableBasicList64<Feature>> pair : clickedFeatures) {
                    FLyrVect layer = (FLyrVect)pair.getLeft();
                    FeatureStore store = layer.getFeatureStore();
                    FeatureSelection selection = store.getFeatureSelection();
                    UnmodifiableBasicList64 features = (UnmodifiableBasicList64)pair.getRight();
                    for (Feature feature : features) {
                        selection.select(feature);
                    }
                }
            }
        }
        catch (DataException e) {
            throw new BehaviorException("Can't do the selection", e);
        }
    }

    protected Geometry getSelectedGeometry() {
        return this.selectedGeom;
    }

    @Override
    public Image getImageCursor() {
        return IconThemeHelper.getImage("cursor-select-by-point");
    }

    @Override
    public boolean cancelDrawing() {
        return false;
    }

    @Override
    public void pointDoubleClick(PointEvent event) throws BehaviorException {
    }
}

