/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.DefaultViewPanel;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.LayersIterator;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTogglePropertyExtension
extends Extension {
    private static Logger logger = LoggerFactory.getLogger(AbstractTogglePropertyExtension.class);

    public void initialize() {
    }

    public void execute(String actionCommand) {
        IWindow v = PluginServices.getMDIManager().getActiveWindow();
        if (!(v instanceof DefaultViewPanel)) {
            logger.info("Executing toggle extension when window is not view (?)");
            return;
        }
        if (actionCommand.compareTo(this.getActionCommand()) != 0) {
            logger.info("Executing toggle extension. Unexpected command: " + actionCommand + ". Expected: " + this.getActionCommand());
            return;
        }
        MapControl mc = ((DefaultViewPanel)v).getMapControl();
        this.doToggleValue(mc);
    }

    public boolean isEnabled() {
        return this.isVisible();
    }

    public boolean isVisible() {
        return this.optionMustBeAvailable();
    }

    protected boolean optionMustBeAvailable() {
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f != null && f instanceof DefaultViewPanel) {
            DefaultViewPanel vista = (DefaultViewPanel)f;
            ViewDocument model = vista.getViewDocument();
            MapContext mapa = model.getMapContext();
            FLayers capas = mapa.getLayers();
            int numActiveVectorial = 0;
            int numActiveVectorialEditable = 0;
            LayersIterator iter = new LayersIterator((FLayer)capas);
            while (iter.hasNext()) {
                FLayer capa = iter.nextLayer();
                if (!(capa instanceof FLyrVect) || !capa.isActive() || !capa.isAvailable()) continue;
                ++numActiveVectorial;
                if (!capa.isEditing()) continue;
                ++numActiveVectorialEditable;
            }
            if (numActiveVectorialEditable == 1 && numActiveVectorial == 1) {
                return true;
            }
        }
        return false;
    }

    protected abstract String getActionCommand();

    protected abstract void doToggleValue(MapControl var1);
}

