/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.gui;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.view.gui.ViewSnappingInfoView;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.SpatialCache;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewSnappingInfoImpl
extends ViewSnappingInfoView {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewSnappingInfoImpl.class);
    private MapContext mapContext;

    public ViewSnappingInfoImpl() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblTolerance);
        toolsSwingManager.translate(this.lblPix);
        toolsSwingManager.translate(this.lblMaxSnappingLayers);
        toolsSwingManager.translate((AbstractButton)this.btnCheckAllSnapping);
        toolsSwingManager.translate((AbstractButton)this.btnUncheckAllSnapping);
        SnappingTableModel model = new SnappingTableModel();
        this.tableSnapping.setModel(model);
        int tolerance = MapControlLocator.getMapControlManager().getTolerance();
        this.textFieldTolSnapping.setText(String.valueOf(tolerance));
        this.btnCheckAllSnapping.addActionListener(e -> this.doCheckAll());
        this.btnUncheckAllSnapping.addActionListener(e -> this.doUncheckAll());
        this.tableSnapping.setSelectionMode(2);
        this.tableSnapping.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getModifiers() == 16) {
                    int row;
                    SnappingTableModel model;
                    model.setValueAt((Boolean)(model = (SnappingTableModel)ViewSnappingInfoImpl.this.tableSnapping.getModel()).getValueAt(row = ViewSnappingInfoImpl.this.tableSnapping.rowAtPoint(e.getPoint()), 0) == false, row, 0);
                    ViewSnappingInfoImpl.this.doUpdateSelectionFromChecks();
                } else {
                    ViewSnappingInfoImpl.this.doUpdateChecksFromSelection();
                }
            }
        });
        this.setPreferredSize(new Dimension(450, 400));
    }

    private void doUpdateChecksFromSelection() {
        SnappingTableModel model = (SnappingTableModel)this.tableSnapping.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            model.setValueAt(this.tableSnapping.isCellSelected(row, 0), row, 0);
        }
    }

    private void doUpdateSelectionFromChecks() {
        SnappingTableModel model = (SnappingTableModel)this.tableSnapping.getModel();
        this.tableSnapping.getSelectionModel().clearSelection();
        for (int row = 0; row < model.getRowCount(); ++row) {
            if (!((Boolean)model.getValueAt(row, 0)).booleanValue()) continue;
            this.tableSnapping.getSelectionModel().addSelectionInterval(row, row);
        }
    }

    private void doUncheckAll() {
        SnappingTableModel model = (SnappingTableModel)this.tableSnapping.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            model.setValueAt(false, row, 0);
        }
        this.doUpdateSelectionFromChecks();
    }

    private void doCheckAll() {
        SnappingTableModel model = (SnappingTableModel)this.tableSnapping.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            model.setValueAt(true, row, 0);
        }
        this.doUpdateSelectionFromChecks();
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        URL url = this.getClass().getResource(name + ".png");
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public void applyChanges() {
        SnappingTableModel model = (SnappingTableModel)this.tableSnapping.getModel();
        HashSet layersToSnap = new HashSet();
        for (int i = 0; i < model.getRowCount(); ++i) {
            SnappingTableModel.TableRow row = model.getRow(i);
            FLyrVect layer = row.getLayer();
            layer.setMaxFeaturesInEditionCache(row.getCacheFeatures());
            layer.setLayerToSnap(row.isSelected());
        }
        try {
            MapControlLocator.getMapControlManager().setTolerance(Integer.parseInt(this.textFieldTolSnapping.getText()));
        }
        catch (Exception e) {
            LOGGER.error(PluginServices.getText((Object)this, (String)"tolerancia_incorrecta"), (Throwable)e);
        }
        this.mapContext.invalidate();
    }

    public void setMapContext(MapContext mapContext) {
        this.mapContext = mapContext;
        ArrayList layers = new ArrayList();
        Iterator layersUnordered = mapContext.deepiterator();
        while (layersUnordered.hasNext()) {
            layers.add(layersUnordered.next());
        }
        Collections.sort(layers, new Comparator<FLayer>(){

            @Override
            public int compare(FLayer o1, FLayer o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        SnappingTableModel model = new SnappingTableModel();
        for (FLayer layer : layers) {
            model.addLayer(layer);
        }
        this.tableSnapping.setModel(model);
    }

    public static class SnappingTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Class<?>[] columnClases = new Class[]{Boolean.class, String.class, Integer.class};
        private List<TableRow> rows;

        public SnappingTableModel() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.rows = new ArrayList<TableRow>();
            this.columnNames = new String[]{i18n.getTranslation("_selected"), i18n.getTranslation("_layer_name"), i18n.getTranslation("_max_number_of_memory_entities")};
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnClases[columnIndex];
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TableRow row = this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return row.isSelected();
                }
                case 1: {
                    if (row.contextEnabled) {
                        return "<html><b>" + row.getLayer().getName() + "</b></html>";
                    }
                    return row.getLayer().getName();
                }
                case 2: {
                    return row.getCacheFeatures();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            TableRow row = this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    row.setSelected((Boolean)aValue);
                    break;
                }
                case 2: {
                    row.setCacheFeatures((Integer)aValue);
                }
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return false;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return true;
                }
            }
            return false;
        }

        public TableRow getRow(int rowIndex) {
            TableRow row = this.rows.get(rowIndex);
            return row;
        }

        private void addLayer(FLayer layer) {
            if (layer instanceof FLyrVect) {
                FLyrVect layerVect = (FLyrVect)layer;
                SpatialCache spatialCache = layerVect.getSpatialCache();
                TableRow row = new TableRow(layerVect, layerVect.isLayerToSnap(), spatialCache.isContextEnabled(), spatialCache.getMaxFeatures());
                this.rows.add(row);
            }
        }

        public class TableRow {
            private final FLyrVect layer;
            private boolean selected;
            private int cacheFeatures;
            private final boolean contextEnabled;

            public TableRow(FLyrVect layer, boolean selected, boolean contextEnabled, int cacheFeatures) {
                this.layer = layer;
                this.selected = selected;
                this.contextEnabled = contextEnabled;
                this.cacheFeatures = cacheFeatures;
            }

            public int getCacheFeatures() {
                return this.cacheFeatures;
            }

            public FLyrVect getLayer() {
                return this.layer;
            }

            public boolean isSelected() {
                return this.selected;
            }

            private void setSelected(boolean aValue) {
                SpatialCache spatialCache = this.layer.getSpatialCache();
                spatialCache.setEnabled(aValue);
                this.selected = aValue;
            }

            private void setCacheFeatures(int aValue) {
                SpatialCache spatialCache = this.layer.getSpatialCache();
                spatialCache.setMaxFeatures(aValue);
                this.cacheFeatures = aValue;
            }
        }
    }
}

