/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners.snapping.snappers;

import java.awt.geom.Point2D;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontrol.PrimitivesDrawer;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.ISnapperVectorial;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.impl.AbstractSnapper;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentroidPointSnapper
extends AbstractSnapper
implements ISnapperVectorial {
    private static final Logger LOGGER = LoggerFactory.getLogger(CentroidPointSnapper.class);

    public Point2D getSnapPoint(Point2D point, Geometry geom, double tolerance, Point2D lastPointEntered) {
        Point2D.Double resul = null;
        try {
            Point centroid = geom.centroid();
            Point2D.Double pointCentroid = new Point2D.Double(centroid.getX(), centroid.getY());
            double dist = pointCentroid.distance(point);
            if (dist < tolerance) {
                resul = pointCentroid;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get centroid.", (Throwable)ex);
        }
        return resul;
    }

    public String getToolTipText() {
        return Messages.getText((String)"_Centroid_point");
    }

    public void draw(PrimitivesDrawer primitivesDrawer, Point2D pPixels) {
        primitivesDrawer.setColor(this.getColor());
        int half = this.getSizePixels() / 2;
        primitivesDrawer.drawOval((int)(pPixels.getX() - (double)half), (int)(pPixels.getY() - (double)half), this.getSizePixels(), this.getSizePixels());
    }
}

