/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners.snapping.snappers;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontrol.PrimitivesDrawer;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.ISnapperGeometriesVectorial;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.impl.AbstractSnapper;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntersectionPointSnapper
extends AbstractSnapper
implements ISnapperGeometriesVectorial {
    private static final Logger LOG = LoggerFactory.getLogger(IntersectionPointSnapper.class);
    public static final int MAX_GEOMETRIES_IN_RELAXED_LIST = 30;
    public static final int MAX_GEOMETRIES_WITHIN_TOLERANCE = 5;
    private List relaxedList = null;
    private GeometryFactory jtsGeoFact = null;
    private long errorMsgCount = 0L;

    public Point2D getSnapPoint(Point2D point, org.gvsig.fmap.geom.Geometry geom, double tolerance, Point2D lastPointEntered) {
        if (geom == null) {
            return null;
        }
        if (this.relaxedList == null || this.relaxedList.size() < 2 || this.relaxedList.size() > 30) {
            return null;
        }
        List<org.gvsig.fmap.geom.Geometry> refinedList = null;
        try {
            refinedList = this.refineList(this.relaxedList, point, tolerance);
        }
        catch (Exception e1) {
            ++this.errorMsgCount;
            if (this.errorMsgCount % 100L == 0L) {
                LOG.info("Error while refining list: " + e1.getMessage());
                this.errorMsgCount = 0L;
            }
            return null;
        }
        if (refinedList.size() > 5) {
            return null;
        }
        List<Point> interPoints = this.getInterPoints(refinedList);
        if (interPoints.size() == 0) {
            return null;
        }
        Geometry jtsg = null;
        try {
            jtsg = (Geometry)geom.invokeOperation("toJTS", null);
        }
        catch (Exception e) {
            ++this.errorMsgCount;
            if (this.errorMsgCount % 100L == 0L) {
                LOG.info("Error while refining list: " + e.getMessage());
                this.errorMsgCount = 0L;
            }
            return null;
        }
        double zerodist = 0.001 * tolerance;
        int n = interPoints.size();
        Point po = null;
        for (int i = 0; i < n; ++i) {
            po = interPoints.get(i);
            if (!(point.distance(po.getX(), po.getY()) < tolerance) || !(jtsg.distance((Geometry)po) < zerodist)) continue;
            return new Point2D.Double(po.getX(), po.getY());
        }
        return null;
    }

    private List<org.gvsig.fmap.geom.Geometry> refineList(List geomlist, Point2D point, double tolerance) throws Exception {
        ArrayList<org.gvsig.fmap.geom.Geometry> resp = new ArrayList<org.gvsig.fmap.geom.Geometry>();
        if (geomlist == null || geomlist.isEmpty()) {
            return resp;
        }
        double point_tol_north = point.getY() + tolerance;
        double point_tol_south = point.getY() - tolerance;
        double point_tol_east = point.getX() + tolerance;
        double point_tol_west = point.getX() - tolerance;
        for (org.gvsig.fmap.geom.Geometry item : geomlist) {
            Envelope interGeom;
            if (!item.intersects((interGeom = GeometryLocator.getGeometryManager().createEnvelope(point_tol_west, point_tol_south, point_tol_east, point_tol_north, 0)).getGeometry())) continue;
            resp.add(item);
        }
        return resp;
    }

    public void draw(PrimitivesDrawer primitivesDrawer, Point2D pPixels) {
        primitivesDrawer.setColor(this.getColor());
        int half = this.getSizePixels() / 2;
        int x1 = (int)(pPixels.getX() - (double)half);
        int x2 = (int)(pPixels.getX() + (double)half);
        int y1 = (int)(pPixels.getY() - (double)half);
        int y2 = (int)(pPixels.getY() + (double)half);
        primitivesDrawer.drawLine(x1, y1, x2, y2);
        primitivesDrawer.drawLine(x1, y2, x2, y1);
    }

    public String getToolTipText() {
        return Messages.getText((String)"_Intersection_point");
    }

    public void setGeometries(List geoms) {
        this.relaxedList = this.leaveUsefulGeometries(geoms);
    }

    private List<Point> getInterPoints(List geomes) {
        ArrayList<Point> resp = new ArrayList<Point>();
        List borders = this.getJTSBorders(geomes);
        Geometry jtsg1 = null;
        Geometry jtsg2 = null;
        Geometry jtsinter = null;
        int n = borders.size();
        Point jtsp = null;
        MultiPoint jtsmp = null;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                if (i == j) continue;
                jtsg1 = (Geometry)borders.get(i);
                jtsinter = jtsg1.intersection(jtsg2 = (Geometry)borders.get(j));
                if (jtsinter instanceof Point) {
                    jtsp = (Point)jtsinter;
                    resp.add(jtsp);
                    continue;
                }
                if (!(jtsinter instanceof MultiPoint)) continue;
                jtsmp = (MultiPoint)jtsinter;
                int m = jtsmp.getNumGeometries();
                for (int k = 0; k < m; ++k) {
                    jtsp = (Point)jtsmp.getGeometryN(k);
                    resp.add(jtsp);
                }
            }
        }
        return resp;
    }

    private List getJTSBorders(List gvsigGeoms) {
        ArrayList<Geometry> resp = new ArrayList<Geometry>();
        Geometry jtsborder = null;
        if (gvsigGeoms != null && gvsigGeoms.size() > 0) {
            Iterator iter = gvsigGeoms.iterator();
            Object itemobj = null;
            while (iter.hasNext()) {
                itemobj = iter.next();
                if (!(itemobj instanceof org.gvsig.fmap.geom.Geometry) || (jtsborder = this.getJTSBorder(itemobj)) == null) continue;
                resp.add(jtsborder);
            }
        }
        return resp;
    }

    private Geometry getJTSBorder(org.gvsig.fmap.geom.Geometry geom) {
        Geometry resp = null;
        if (geom instanceof Curve || geom instanceof MultiCurve) {
            try {
                resp = (Geometry)geom.invokeOperation("toJTS", null);
            }
            catch (Exception e) {
                ++this.errorMsgCount;
                if (this.errorMsgCount % 100L == 0L) {
                    LOG.info("Error while refining list: " + e.getMessage());
                    this.errorMsgCount = 0L;
                }
                return null;
            }
            return resp;
        }
        if (geom instanceof Surface || geom instanceof MultiSurface) {
            try {
                resp = (Geometry)geom.invokeOperation("toJTS", null);
                return resp.getBoundary();
            }
            catch (Exception e) {
                ++this.errorMsgCount;
                if (this.errorMsgCount % 100L == 0L) {
                    LOG.info("Error while refining list: " + e.getMessage());
                    this.errorMsgCount = 0L;
                }
                return null;
            }
        }
        return null;
    }

    private List<org.gvsig.fmap.geom.Geometry> leaveUsefulGeometries(List geoms) {
        ArrayList<org.gvsig.fmap.geom.Geometry> resp = new ArrayList<org.gvsig.fmap.geom.Geometry>();
        if (geoms == null || geoms.size() == 0) {
            return resp;
        }
        Object item2 = null;
        for (Object item2 : geoms) {
            if (!(item2 instanceof Curve) && !(item2 instanceof Surface) && !(item2 instanceof MultiCurve) && !(item2 instanceof MultiSurface)) continue;
            resp.add((org.gvsig.fmap.geom.Geometry)item2);
        }
        return resp;
    }
}

