/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.xml;

import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemData;
import net.sf.jasperreports.customvisualization.xml.CVItemDatasetFactory;
import net.sf.jasperreports.customvisualization.xml.CVItemPropertyXmlFactory;
import net.sf.jasperreports.customvisualization.xml.CVXmlFactory;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.component.XmlDigesterConfigurer;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.JREnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.xml.JRExpressionFactory;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.engine.xml.XmlConstantPropertyRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;

public class CVDigester
implements XmlDigesterConfigurer {
    public void configureDigester(Digester digester) {
        CVDigester.addRules(digester);
    }

    public static void addRules(Digester digester) {
        String namespace = digester.getRuleNamespaceURI();
        String mainComponentPattern = "*/componentElement/customvisualization";
        digester.addFactoryCreate(mainComponentPattern, CVXmlFactory.class.getName());
        CVDigester.addEvaluationPropertiesRules(digester, mainComponentPattern);
        CVDigester.addItemPropertieyRules(digester, mainComponentPattern + "/" + "itemProperty", namespace);
        CVDigester.addCVItemDataRules(digester, mainComponentPattern + "/" + "cvData", namespace);
    }

    protected static void addExpressionRules(Digester digester, String expressionPattern, String setterMethod, boolean jrNamespace) {
        String originalNamespace = digester.getRuleNamespaceURI();
        if (jrNamespace) {
            digester.setRuleNamespaceURI(JRXmlWriter.JASPERREPORTS_NAMESPACE.getNamespaceURI());
        }
        digester.addFactoryCreate(expressionPattern, JRExpressionFactory.class);
        digester.addCallMethod(expressionPattern, "setText", 0);
        digester.addSetNext(expressionPattern, setterMethod, JRExpression.class.getName());
        if (jrNamespace) {
            digester.setRuleNamespaceURI(originalNamespace);
        }
    }

    protected static void addEvaluationPropertiesRules(Digester digester, String pattern) {
        digester.addSetProperties(pattern, new String[]{"evaluationTime", "onErrorType"}, new String[0]);
        digester.addRule(pattern, (Rule)new XmlConstantPropertyRule("evaluationTime", "evaluationTimeValue", (JREnum[])EvaluationTimeEnum.values()));
        digester.addRule(pattern, (Rule)new XmlConstantPropertyRule("onErrorType", (JREnum[])OnErrorTypeEnum.values()));
    }

    protected static void addItemPropertieyRules(Digester digester, String itemPropertyPattern, String namespace) {
        digester.addFactoryCreate(itemPropertyPattern, CVItemPropertyXmlFactory.class);
        digester.addSetNext(itemPropertyPattern, "addItemProperty", ItemProperty.class.getName());
        CVDigester.addExpressionRules(digester, itemPropertyPattern + "/" + "valueExpression", "setValueExpression", true);
    }

    protected static void addCVItemDataRules(Digester digester, String pattern, String namespace) {
        digester.addObjectCreate(pattern, StandardItemData.class);
        digester.addSetNext(pattern, "addItemData", StandardItemData.class.getName());
        String itemPattern = pattern + "/item";
        digester.addObjectCreate(itemPattern, StandardItem.class);
        digester.addSetNext(itemPattern, "addItem", Item.class.getName());
        CVDigester.addItemPropertieyRules(digester, itemPattern + "/itemProperty", namespace);
        digester.setRuleNamespaceURI(JRXmlWriter.JASPERREPORTS_NAMESPACE.getNamespaceURI());
        digester.addFactoryCreate(pattern + "/dataset", CVItemDatasetFactory.class.getName());
        digester.addSetNext(pattern + "/dataset", "setDataset", JRElementDataset.class.getName());
        digester.setRuleNamespaceURI(namespace);
    }
}

