/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.xml;

import java.io.IOException;
import java.util.List;
import net.sf.jasperreports.components.AbstractComponentXmlWriter;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.customvisualization.CVComponent;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.JREnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class CVXmlWriter
extends AbstractComponentXmlWriter {
    public CVXmlWriter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    public void writeCV(JRComponentElement componentElement, JRXmlWriter reportWriter) throws IOException {
        Component component = componentElement.getComponent();
        CVComponent comp = (CVComponent)component;
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        ComponentKey componentKey = componentElement.getComponentKey();
        XmlNamespace namespace = new XmlNamespace("http://www.jaspersoft.com/cvcomponent", componentKey.getNamespacePrefix(), "http://www.jaspersoft.com/cvcomponent/component.xsd");
        writer.startElement("customvisualization", namespace);
        writer.addAttribute("evaluationTime", (JREnum)comp.getEvaluationTime(), (JREnum)EvaluationTimeEnum.NOW);
        if (comp.getEvaluationGroup() != null && comp.getEvaluationGroup().trim().length() > 0) {
            writer.addAttribute("evaluationGroup", comp.getEvaluationGroup());
        }
        writer.addAttribute("processingClass", comp.getProcessingClass());
        writer.addAttribute("onErrorType", (JREnum)comp.getOnErrorType(), (JREnum)OnErrorTypeEnum.ERROR);
        List<ItemProperty> itemProperties = comp.getItemProperties();
        for (ItemProperty itemProperty : itemProperties) {
            this.writeCVItemProperty(itemProperty, writer, reportWriter, namespace, componentElement);
        }
        List<ItemData> itemDataList = comp.getItemData();
        for (ItemData itemData : itemDataList) {
            if (itemData == null) continue;
            this.writeItemDataset(itemData, writer, reportWriter, namespace, componentElement);
        }
        writer.closeElement();
    }

    private void writeCVItemProperty(ItemProperty itemProperty, JRXmlWriteHelper writer, JRXmlWriter reportWriter, XmlNamespace namespace, JRComponentElement componentElement) throws IOException {
        writer.startElement("itemProperty", namespace);
        writer.addAttribute("name", itemProperty.getName());
        if (itemProperty.getValue() != null) {
            writer.addAttribute("value", itemProperty.getValue());
        }
        this.writeExpression("valueExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, itemProperty.getValueExpression(), false, componentElement, reportWriter);
        writer.closeElement();
    }

    private void writeItemDataset(ItemData itemDataset, JRXmlWriteHelper writer, JRXmlWriter reportWriter, XmlNamespace namespace, JRComponentElement componentElement) throws IOException {
        List itemList;
        writer.startElement("cvData", namespace);
        JRElementDataset dataset = itemDataset.getDataset();
        if (dataset != null) {
            reportWriter.writeElementDataset(dataset, false);
        }
        if ((itemList = itemDataset.getItems()) != null && !itemList.isEmpty()) {
            for (Item item : itemList) {
                writer.startElement("item", namespace);
                if (item.getProperties() != null && !item.getProperties().isEmpty()) {
                    for (ItemProperty itemProperty : item.getProperties()) {
                        if (itemProperty == null) continue;
                        this.writeCVItemProperty(itemProperty, writer, reportWriter, namespace, componentElement);
                    }
                }
                writer.closeElement();
            }
        }
        writer.closeElement();
    }

    public boolean isToWrite(JRComponentElement jrce, JRXmlWriter writer) {
        return true;
    }

    public void writeToXml(JRComponentElement componentElement, JRXmlWriter reportWriter) throws IOException {
        Component component = componentElement.getComponent();
        if (component instanceof CVComponent) {
            this.writeCV(componentElement, reportWriter);
        }
    }
}

