/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xmlschema.prov.kxml.model;

import java.io.IOException;
import java.util.Vector;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlschema.lib.api.som.IXSComplexTypeDefinition;
import org.gvsig.xmlschema.lib.api.som.IXSElementDeclaration;
import org.gvsig.xmlschema.lib.api.som.IXSTypeDefinition;
import org.gvsig.xmlschema.lib.api.som.XSQName;
import org.gvsig.xmlschema.prov.kxml.model.AbstractXSComponent;
import org.gvsig.xmlschema.prov.kxml.model.XSSchema;

public class XSElementDeclaration
extends AbstractXSComponent
implements IXSElementDeclaration {
    private String reference = null;
    private IXSTypeDefinition type = null;
    private String typeUnknown = null;
    private int minOccurs = -1;
    private int maxOccurs = -1;
    private int totalDigits = 0;
    private int fractionDigits = 0;
    private XSElementDeclaration parentElement = null;

    public XSElementDeclaration(XSSchema schema, IXmlStreamReader parser) throws IOException {
        super(schema);
        this.parse(parser);
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public void setEntityType(String type) {
        IXSTypeDefinition xmlType = this.schema.getTypeByName(null, type);
        if (xmlType == null) {
            String[] types = type.split(":");
            if (types.length == 1) {
                xmlType = this.schema.getTypeByName(null, "XS:" + type);
            }
            if (xmlType == null) {
                xmlType = this.schema.getTypeByName(null, "GML:" + type);
            }
            if (xmlType == null) {
                this.typeUnknown = type;
            }
        }
        this.type = xmlType;
    }

    public String toString() {
        return this.qName.getLocalPart();
    }

    private void parse(IXmlStreamReader parser) throws IOException {
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if ("name".equals(parser.getAttributeName(i).getLocalPart())) {
                this.qName = new XSQName(parser.getAttributeValue(i));
                continue;
            }
            if ("type".equals(parser.getAttributeName(i).getLocalPart())) {
                this.setEntityType(parser.getAttributeValue(i));
                continue;
            }
            if ("maxOccurs".equals(parser.getAttributeName(i).getLocalPart())) {
                try {
                    this.setMaxOccurs(Integer.parseInt(parser.getAttributeValue(i)));
                }
                catch (NumberFormatException e) {
                    this.setMaxOccurs(-1);
                }
                continue;
            }
            if ("minOccurs".equals(parser.getAttributeName(i).getLocalPart())) {
                try {
                    this.setMinOccurs(Integer.parseInt(parser.getAttributeValue(i)));
                }
                catch (NumberFormatException e) {
                    this.setMinOccurs(-1);
                }
                continue;
            }
            if (!"ref".equals(parser.getAttributeName(i).getLocalPart())) continue;
            this.setReference(parser.getAttributeValue(i));
        }
    }

    public void parseSimpleType(IXmlStreamReader parser) throws IOException {
        boolean end = false;
        int currentTag = parser.getEventType();
        while (!end) {
            switch (currentTag) {
                case 1: {
                    if (!"restriction".equals(parser.getName().getLocalPart())) break;
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        if (!"base".equals(parser.getAttributeName(i).getLocalPart())) continue;
                        this.setEntityType(parser.getAttributeValue(i));
                    }
                    this.parseRestriction(parser);
                    break;
                }
                case 2: {
                    if (!"simpleType".equals(parser.getName().getLocalPart())) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private void parseRestriction(IXmlStreamReader parser) throws IOException {
        boolean end = false;
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 1: {
                    int i;
                    if ("totalDigits".equals(parser.getName().getLocalPart())) {
                        for (i = 0; i < parser.getAttributeCount(); ++i) {
                            if (!"value".equals(parser.getAttributeName(i).getLocalPart())) continue;
                            this.setTotalDigits(Integer.parseInt(parser.getAttributeValue(i)));
                        }
                    } else {
                        if (!"fractionDigits".equals(parser.getName().getLocalPart())) break;
                        for (i = 0; i < parser.getAttributeCount(); ++i) {
                            if (!"value".equals(parser.getAttributeName(i).getLocalPart())) continue;
                            this.setFractionDigits(Integer.parseInt(parser.getAttributeValue(i)));
                        }
                    }
                    break;
                }
                case 2: {
                    if (!"restriction".equals(parser.getName().getLocalPart())) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    public void setFractionDigits(int fractionDigits) {
        this.fractionDigits = fractionDigits;
    }

    public int getTotalDigits() {
        return this.totalDigits;
    }

    public void setTotalDigits(int totalDigits) {
        this.totalDigits = totalDigits;
    }

    public IXSElementDeclaration getParentElement() {
        return this.parentElement;
    }

    public void setParentElement(XSElementDeclaration parentElement) {
        this.parentElement = parentElement;
    }

    public String getFullName() {
        String path = this.qName.getLocalPart();
        for (IXSElementDeclaration parent = this.getParentElement(); parent != null; parent = parent.getParentElement()) {
            if (parent.getParentElement() == null) continue;
            path = parent.getQName().getLocalPart() + "/" + path;
        }
        return path;
    }

    public XSElementDeclaration searchAttribute(String attName) {
        return this.searchAttribute(attName, this.qName.getLocalPart());
    }

    private XSElementDeclaration searchAttribute(String attName, String fullName) {
        return null;
    }

    public Vector getChildren() {
        return new Vector();
    }

    public boolean isMultiple() {
        return this.maxOccurs != 1;
    }

    public IXSComplexTypeDefinition addComplexType(String type, String contentType, String contentTypeRestriction) {
        return null;
    }

    public IXSElementDeclaration getSubElementByName(String name) {
        return null;
    }

    public IXSTypeDefinition getTypeDefinition() {
        if (this.type != null) {
            return this.type;
        }
        if (this.typeUnknown != null) {
            this.type = this.schema.getTypeByName(null, this.typeUnknown);
        }
        if (this.type == null && this.typeUnknown != null && this.typeUnknown.split(":").length > 1) {
            this.type = this.schema.getTypeByName(null, null + ":" + this.typeUnknown.split(":")[1]);
            if (this.type == null) {
                this.type = this.schema.getTypeByName(null, this.typeUnknown.split(":")[1]);
            }
        }
        return this.type;
    }

    public String getTypeName() {
        IXSTypeDefinition typeDefinition = this.getTypeDefinition();
        if (typeDefinition != null) {
            return typeDefinition.getNodeName();
        }
        return null;
    }

    public boolean isNillable() {
        return false;
    }

    public short getNodeType() {
        return 0;
    }

    public String getNodeValue() {
        return null;
    }
}

