/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xmlschema.prov.kxml.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gvsig.xmlpull.lib.api.XmlPullLocator;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;
import org.gvsig.xmlschema.lib.api.XMLSchemaLocator;
import org.gvsig.xmlschema.lib.api.XMLSchemaManager;
import org.gvsig.xmlschema.lib.api.exceptions.SchemaWrittingException;
import org.gvsig.xmlschema.lib.api.som.IXSComplexTypeDefinition;
import org.gvsig.xmlschema.lib.api.som.IXSDocument;
import org.gvsig.xmlschema.lib.api.som.IXSElementDeclaration;
import org.gvsig.xmlschema.lib.api.som.IXSSchema;
import org.gvsig.xmlschema.lib.api.som.IXSTypeDefinition;
import org.gvsig.xmlschema.lib.api.utils.SchemaObjectsMapping;
import org.gvsig.xmlschema.prov.kxml.model.XSComplexTypeDefinition;
import org.gvsig.xmlschema.prov.kxml.model.XSElement;
import org.gvsig.xmlschema.prov.kxml.model.XSimpleTypeDefinition;

public class XSSchema
implements IXSSchema {
    private String targetNameSpace = null;
    private String version = null;
    private Hashtable types = new Hashtable();
    private List elements = new ArrayList();
    private XMLSchemaManager schemaManager = XMLSchemaLocator.getXMLSchemaManager();

    public XSSchema(InputStream is) throws IOException {
        IXmlStreamReader xmlStreamReader = XmlPullLocator.getXMLManager().createStreamReader("text/xml", is);
        this.parse(xmlStreamReader);
    }

    private void parse(IXmlStreamReader xmlStreamReader) throws IOException {
        while (xmlStreamReader.getEventType() != 1) {
            xmlStreamReader.next();
            if (xmlStreamReader.getEventType() != 8) continue;
            return;
        }
        this.parseHeader(xmlStreamReader);
        int tag = xmlStreamReader.nextTag();
        while (tag != 8) {
            switch (tag) {
                case 1: {
                    if ("complexType".equals(xmlStreamReader.getName().getLocalPart())) {
                        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                            if (!"name".equals(xmlStreamReader.getAttributeName(i).getLocalPart())) continue;
                            XSComplexTypeDefinition complexTypeDefinition = new XSComplexTypeDefinition(this, null, xmlStreamReader.getAttributeValue(i), xmlStreamReader);
                            this.addType(complexTypeDefinition);
                        }
                        break;
                    }
                    if ("simpleType".equals(xmlStreamReader.getName().getLocalPart())) {
                        this.parseSimpleType(xmlStreamReader);
                        break;
                    }
                    if (!"element".equals(xmlStreamReader.getName().getLocalPart())) break;
                    XSElement element = new XSElement(this, xmlStreamReader);
                    this.elements.add(element);
                    break;
                }
                case 2: {
                    break;
                }
            }
            tag = xmlStreamReader.next();
        }
    }

    private void parseHeader(IXmlStreamReader xmlStreamReader) throws XmlStreamException {
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String attName = xmlStreamReader.getAttributeName(i).getLocalPart();
            String attValue = xmlStreamReader.getAttributeValue(i);
            if ("targetNamespace".equals(attName)) {
                this.targetNameSpace = attValue;
            }
            if (" elementFormDefault".equals(attName)) {
                // empty if block
            }
            if ("attributeFormDefault".equals(attName)) {
                // empty if block
            }
            if (!"version".equals(attName)) continue;
            this.version = attValue;
        }
    }

    private void parseSimpleType(IXmlStreamReader xmlStreamReader) throws IOException {
        int i;
        boolean end = false;
        int currentTag = xmlStreamReader.getEventType();
        String typeName = null;
        String typeValue = null;
        for (i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            if (!"name".equals(xmlStreamReader.getName().getLocalPart())) continue;
            typeName = xmlStreamReader.getAttributeValue(i);
        }
        while (!end) {
            switch (currentTag) {
                case 1: {
                    if (!"restriction".equals(xmlStreamReader.getName().getLocalPart())) break;
                    for (i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
                        if (!"base".equals(xmlStreamReader.getName().getLocalPart())) continue;
                        typeValue = xmlStreamReader.getAttributeValue(i);
                    }
                    break;
                }
                case 2: {
                    if (!"simpleType".equals(xmlStreamReader.getName().getLocalPart())) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = xmlStreamReader.next();
        }
        if (typeName != null && typeValue != null) {
            this.addType(new XSimpleTypeDefinition(this, typeName, typeValue));
        }
    }

    void addType(IXSTypeDefinition typeDefinition) {
        this.types.put(typeDefinition.getTypeName().toUpperCase(), typeDefinition);
    }

    public IXSComplexTypeDefinition addComplexType(String name, String type, String contentType, String conteTypeRestriction) {
        return null;
    }

    public IXSElementDeclaration addElement(String name, String type, String substitutionGroup) {
        return null;
    }

    public IXSElementDeclaration addElement(String name, String type) {
        return null;
    }

    public IXSDocument getDocument() {
        return null;
    }

    public IXSElementDeclaration getElementDeclarationByName(String targetNamespace, String elementName) {
        for (IXSElementDeclaration elementDeclaration : this.elements) {
            if (!elementName.equals(elementDeclaration.getQName().getLocalPart())) continue;
            return elementDeclaration;
        }
        return null;
    }

    public Collection getElementDeclarations() {
        return this.elements;
    }

    public String getNamespacePrefix(String namespaceURI) {
        return null;
    }

    public SchemaObjectsMapping getObjectsMapping() {
        return null;
    }

    public String getTargetNamespace() {
        return null;
    }

    public String getTargetNamespacePrefix() {
        return null;
    }

    public IXSTypeDefinition getTypeByName(String targetNamespace, String typeName) {
        IXSTypeDefinition xmlType = (IXSTypeDefinition)this.types.get(typeName.toUpperCase());
        if (xmlType == null) {
            xmlType = this.schemaManager.getTypeDefinition(typeName);
        }
        if (xmlType == null) {
            xmlType = this.getTypeWithOutNameSpace(typeName);
        }
        return xmlType;
    }

    private IXSTypeDefinition getTypeWithOutNameSpace(String typeName) {
        Set keys = this.types.keySet();
        Iterator it = keys.iterator();
        String[] typeParts = typeName.split(":");
        String typeAux = typeName;
        if (typeParts.length > 1) {
            typeAux = typeParts[1];
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            String[] parts = key.split(":");
            if (!(parts.length == 1 ? parts[0].compareTo(typeAux.toUpperCase()) == 0 : parts.length > 1 && parts[parts.length - 1].compareTo(typeAux.toUpperCase()) == 0)) continue;
            return (IXSTypeDefinition)this.types.get(key);
        }
        return null;
    }

    public Collection getTypeDefinitions() {
        return null;
    }

    public void write(OutputStream os) throws SchemaWrittingException {
    }
}

