/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.reproject;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.geoprocess.algorithm.reproject.ReprojectOperation;
import org.gvsig.geoprocess.algorithm.reproject.ReprojectParametersPanel;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.task.SimpleTaskStatus;

public class ReprojectAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String RESULT_POL = "RESULT_POL";
    public static final String RESULT_POINT = "RESULT_POINT";
    public static final String RESULT_LINE = "RESULT_LINE";
    public static final String LAYER = "LAYER";
    public static final String SELECTED_GEOM = "SELECTED_GEOM";
    public static final String DST_PROJECTION = "DST_PROJECTION";

    public void defineCharacteristics() {
        this.setName(this.getTranslation("Reproject"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, this.getTranslation("Input_layer"), -1, true);
            this.m_Parameters.addBoolean(SELECTED_GEOM, this.getTranslation("Selected_geometries"), false);
            this.m_Parameters.addString(DST_PROJECTION, this.getTranslation("Projection"));
            this.addOutputVectorLayer(RESULT_POL, this.getTranslation("Reproject_polygon"), 2);
            this.addOutputVectorLayer(RESULT_LINE, this.getTranslation("Reproject_line"), 1);
            this.addOutputVectorLayer(RESULT_POINT, this.getTranslation("Reproject_point"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT_POL, 0) || this.existsOutPutFile(RESULT_LINE, 0) || this.existsOutPutFile(RESULT_POINT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        boolean selectedGeom = this.m_Parameters.getParameterValueAsBoolean(SELECTED_GEOM);
        String dstProj = this.m_Parameters.getParameterValueAsString(DST_PROJECTION);
        FeatureStore storeLayer = null;
        if (!(layer instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        storeLayer = ((FlyrVectIVectorLayer)layer).getFeatureStore();
        try {
            FeatureStore outFeatStore;
            FeatureSet features = null;
            features = storeLayer.getFeatureSet();
            FeatureType featureType = features.getDefaultFeatureType();
            IProjection projOutput = CRSFactory.getCRS((String)dstProj);
            ReprojectOperation operation = new ReprojectOperation((IProjection)layer.getCRS(), projOutput, this);
            operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
            if (this.isPolygon(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStore = this.buildOutPutStore(featureType, 6, this.getTranslation("Reproject_polygon"), RESULT_POL);
                operation.computesFeatureOperation(storeLayer, outFeatStore, this.attrNames, selectedGeom, false, true);
            } else {
                this.buildOutPutStore(featureType, 6, this.getTranslation("Null_polygon"), RESULT_POL);
            }
            if (this.isLine(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStore = this.buildOutPutStore(featureType, 5, this.getTranslation("Reproject_line"), RESULT_LINE);
                operation.computesFeatureOperation(storeLayer, outFeatStore, this.attrNames, selectedGeom, false, true);
            } else {
                this.buildOutPutStore(featureType.getCopy(), 5, this.getTranslation("Null_line"), RESULT_LINE);
            }
            if (this.isPoint(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStore = this.buildOutPutStore(featureType.getCopy(), 0, this.getTranslation("Reproject_point"), RESULT_POINT);
                operation.computesFeatureOperation(storeLayer, outFeatStore, this.attrNames, selectedGeom, false, true);
            } else {
                this.buildOutPutStore(featureType.getCopy(), 0, this.getTranslation("Null_point"), RESULT_POINT);
            }
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return !this.getTaskMonitor().isCanceled();
    }

    public Class<? extends GeoAlgorithmParametersPanel> getCustomParametersPanelClass() {
        return ReprojectParametersPanel.class;
    }
}

