/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.reproject;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.algorithm.OutputChannelSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.outputs.Output;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cresques.cts.IProjection;
import org.gvsig.app.gui.panels.CRSSelectPanel;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.geoprocess.lib.api.GeoProcessLocator;
import org.gvsig.geoprocess.sextante.gui.algorithm.AlgorithmOutputPanel;

public class ReprojectParametersPanel
extends GeoAlgorithmParametersPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private GeoAlgorithm m_Algorithm = null;
    private JComboBox layersCombo = null;
    private JCheckBox selectionOnly = null;
    private JLabel projLabel = null;
    private CRSSelectPanel projectionSrcSelector = null;
    private IProjection targetLayerProjection = null;
    private AlgorithmOutputPanel algorithmOutputPanel = null;
    private OutputChannelSelectionPanel outputChannelSelectionPanelPol;
    private OutputChannelSelectionPanel outputChannelSelectionPanelLine;
    private OutputChannelSelectionPanel outputChannelSelectionPanelPoint;
    private JPanel outputPanel;

    public void init(GeoAlgorithm algorithm) {
        this.m_Algorithm = algorithm;
        this.initGUI();
        this.init();
    }

    private void initGUI() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(15, 5, 15, 0);
        this.add(this.getComboPanel(GeoProcessLocator.getGeoProcessManager().getTranslation("Input_layer"), this.getLayersCombo()), gbc);
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 5, 15, 0);
        this.add(this.getSelectionCheck(), gbc);
        gbc.gridy = 2;
        this.add(this.getCurrentProjLabel(), gbc);
        gbc.gridy = 3;
        this.add((Component)this.getProjectionSelector(), gbc);
        gbc.gridy = 4;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.add(new JPanel(), gbc);
        gbc.gridy = 5;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.add(this.getOutputChannelSelectionPanel(), gbc);
    }

    private JPanel getOutputChannelSelectionPanel() {
        if (this.outputPanel == null) {
            try {
                this.outputPanel = new JPanel();
                this.outputPanel.setLayout(new GridBagLayout());
                OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
                Output out_pol = ooSet.getOutput("RESULT_POL");
                Output out_line = ooSet.getOutput("RESULT_LINE");
                Output out_point = ooSet.getOutput("RESULT_POINT");
                this.outputChannelSelectionPanelPol = new OutputChannelSelectionPanel(out_pol, this.m_Algorithm.getParameters());
                this.outputChannelSelectionPanelLine = new OutputChannelSelectionPanel(out_line, this.m_Algorithm.getParameters());
                this.outputChannelSelectionPanelPoint = new OutputChannelSelectionPanel(out_point, this.m_Algorithm.getParameters());
                String label = GeoProcessLocator.getGeoProcessManager().getTranslation("Reproject");
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.fill = 2;
                gbc.insets = new Insets(0, 0, 4, 0);
                gbc.weightx = 1.0;
                gbc.gridx = 0;
                gbc.gridy = 0;
                this.outputPanel.add((Component)new JLabel(" " + label + " [" + GeoProcessLocator.getGeoProcessManager().getTranslation("Polygon") + "]               "), gbc);
                gbc.gridx = 0;
                gbc.gridy = 1;
                this.outputPanel.add((Component)new JLabel(" " + label + " [" + GeoProcessLocator.getGeoProcessManager().getTranslation("Line") + "]               "), gbc);
                gbc.gridx = 0;
                gbc.gridy = 2;
                this.outputPanel.add((Component)new JLabel(" " + label + " [" + GeoProcessLocator.getGeoProcessManager().getTranslation("Point") + "]               "), gbc);
                gbc.fill = 2;
                gbc.weightx = 1.0;
                gbc.gridx = 1;
                gbc.gridy = 0;
                this.outputPanel.add((Component)this.outputChannelSelectionPanelPol, gbc);
                gbc.gridx = 1;
                gbc.gridy = 1;
                this.outputPanel.add((Component)this.outputChannelSelectionPanelLine, gbc);
                gbc.gridx = 1;
                gbc.gridy = 2;
                this.outputPanel.add((Component)this.outputChannelSelectionPanelPoint, gbc);
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        return this.outputPanel;
    }

    private AlgorithmOutputPanel getAlgorithmOutputPanel() {
        if (this.algorithmOutputPanel == null) {
            this.algorithmOutputPanel = new AlgorithmOutputPanel();
        }
        return this.algorithmOutputPanel;
    }

    public JPanel getComboPanel(String text, JComboBox combo) {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 2, 0, 50);
        JLabel label = new JLabel(text);
        label.setPreferredSize(new Dimension(180, 18));
        panel.add((Component)label, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 2, 0, 0);
        panel.add((Component)combo, gbc);
        return panel;
    }

    public JComboBox getLayersCombo() {
        if (this.layersCombo == null) {
            this.layersCombo = new JComboBox();
            this.layersCombo.setPreferredSize(new Dimension(0, 18));
            DefaultComboBoxModel<ObjectAndDescription> comboModel = new DefaultComboBoxModel<ObjectAndDescription>(this.getLayerList());
            this.layersCombo.setModel(comboModel);
            this.layersCombo.addActionListener(this);
        }
        return this.layersCombo;
    }

    public JCheckBox getSelectionCheck() {
        if (this.selectionOnly == null) {
            this.selectionOnly = new JCheckBox(GeoProcessLocator.getGeoProcessManager().getTranslation("Selected_geometries"));
        }
        return this.selectionOnly;
    }

    private CRSSelectPanel getProjectionSelector() {
        if (this.projectionSrcSelector == null) {
            this.targetLayerProjection = CRSFactory.getCRS((String)"EPSG:23030");
            this.projectionSrcSelector = CRSSelectPanel.getPanel((IProjection)this.targetLayerProjection);
            this.projectionSrcSelector.getJLabel().setText(GeoProcessLocator.getGeoProcessManager().getTranslation("Proyeccion_Destino"));
            this.projectionSrcSelector.setPreferredSize(new Dimension(330, 35));
            this.projectionSrcSelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ReprojectParametersPanel.this.projectionSrcSelector.isOkPressed()) {
                        ReprojectParametersPanel.this.targetLayerProjection = ReprojectParametersPanel.this.projectionSrcSelector.getCurProj();
                    }
                }
            });
        }
        this.projectionSrcSelector.setTransPanelActive(true);
        return this.projectionSrcSelector;
    }

    public JLabel getCurrentProjLabel() {
        if (this.projLabel == null) {
            this.projLabel = new JLabel();
        }
        return this.projLabel;
    }

    private void init() {
        IVectorLayer layer = this.getSelectedVectorLayer();
        IProjection currentProj = (IProjection)layer.getCRS();
        this.getCurrentProjLabel().setText(GeoProcessLocator.getGeoProcessManager().getTranslation("current_proj") + ": " + currentProj.getAbrev());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getLayersCombo()) {
            this.init();
        }
    }

    public void assignParameters() {
        try {
            ParametersSet params = this.m_Algorithm.getParameters();
            params.getParameter("LAYER").setParameterValue((Object)this.getSelectedVectorLayer());
            params.getParameter("SELECTED_GEOM").setParameterValue((Object)this.getSelectionCheck().isSelected());
            String proj = this.getProjectionSelector().getCurProj().getFullCode();
            params.getParameter("DST_PROJECTION").setParameterValue((Object)proj);
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            Output outPol = ooSet.getOutput("RESULT_POL");
            Output outLine = ooSet.getOutput("RESULT_LINE");
            Output outPoint = ooSet.getOutput("RESULT_POINT");
            outPol.setOutputChannel(this.outputChannelSelectionPanelPol.getOutputChannel());
            outLine.setOutputChannel(this.outputChannelSelectionPanelLine.getOutputChannel());
            outPoint.setOutputChannel(this.outputChannelSelectionPanelPoint.getOutputChannel());
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void setOutputValue(String arg0, String arg1) {
    }

    public void setParameterValue(String arg0, String arg1) {
    }

    private ObjectAndDescription[] getLayerList() {
        IVectorLayer[] layers = SextanteGUI.getInputFactory().getVectorLayers(-1);
        ObjectAndDescription[] oad = new ObjectAndDescription[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            oad[i] = new ObjectAndDescription(layers[i].getName(), (Object)layers[i]);
        }
        return oad;
    }

    private IVectorLayer getSelectedVectorLayer() {
        if (this.layersCombo.getSelectedItem() != null) {
            return (IVectorLayer)((ObjectAndDescription)this.layersCombo.getSelectedItem()).getObject();
        }
        return null;
    }

    public String[] getFieldList() {
        IVectorLayer layer = this.getSelectedVectorLayer();
        String[] data = new String[layer.getFieldCount()];
        for (int i = 0; i < layer.getFieldCount(); ++i) {
            data[i] = layer.getFieldName(i);
        }
        return data;
    }
}

