/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import org.geotools.coverage.CategoryList;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.AbstractGridCoverage;
import org.geotools.resources.gcs.Resources;
import org.geotools.resources.image.DualRectIter;

final class SampleTranscoder
extends PointOpImage {
    public static final String OPERATION_NAME = "org.geotools.SampleTranscode";
    private final CategoryList[] categories;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class array$Lorg$geotools$coverage$GridSampleDimension;

    private SampleTranscoder(RenderedImage image, CategoryList[] categories, RenderingHints hints) {
        super(image, (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT), (Map)hints, false);
        this.categories = categories;
        if (categories.length != image.getSampleModel().getNumBands()) {
            throw new RasterFormatException(String.valueOf(categories.length));
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        PlanarImage source = sources[0];
        WritableRectIter iterator = RectIterFactory.createWritable((WritableRaster)dest, (Rectangle)destRect);
        iterator = DualRectIter.create(RectIterFactory.create((RenderedImage)source, (Rectangle)destRect), iterator);
        int band = 0;
        if (!iterator.finishedBands()) {
            do {
                this.categories[band].transform(iterator);
                ++band;
            } while (!iterator.nextBandDone());
        }
        if (!$assertionsDisabled && band != this.categories.length) {
            throw new AssertionError(band);
        }
    }

    public static void register(JAI jai) {
        OperationRegistry registry = jai.getOperationRegistry();
        try {
            registry.registerDescriptor((RegistryElementDescriptor)new Descriptor());
            registry.registerFactory("rendered", OPERATION_NAME, "geotools.org", (Object)new CRIF());
        }
        catch (IllegalArgumentException exception) {
            LogRecord record = Resources.getResources(null).getLogRecord(Level.SEVERE, 46, OPERATION_NAME);
            record.setSourceClassName("GridSampleDimension");
            record.setSourceMethodName("<classinit>");
            record.setThrown(exception);
            AbstractGridCoverage.LOGGER.log(record);
        }
    }

    static {
        $assertionsDisabled = !SampleTranscoder.class.desiredAssertionStatus();
    }

    private static final class CRIF
    extends CRIFImpl {
        private CRIF() {
        }

        public RenderedImage create(ParameterBlock param, RenderingHints hints) {
            SampleTranscoder other;
            RenderedImage image = (RenderedImage)param.getSource(0);
            GridSampleDimension[] bands = (GridSampleDimension[])param.getObjectParameter(0);
            CategoryList[] categories = new CategoryList[bands.length];
            for (int i = 0; i < categories.length; ++i) {
                categories[i] = bands[i].categories;
            }
            if (image instanceof SampleTranscoder && CRIF.isInverse(categories, (other = (SampleTranscoder)((Object)image)).categories)) {
                return other.getSourceImage(0);
            }
            return new SampleTranscoder(image, categories, hints);
        }

        private static boolean isInverse(CategoryList[] categories1, CategoryList[] categories2) {
            if (categories1.length != categories2.length) {
                return false;
            }
            for (int i = 0; i < categories1.length; ++i) {
                if (categories1[i].equals(categories2[i].inverse)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Descriptor
    extends OperationDescriptorImpl {
        public Descriptor() {
            super((String[][])new String[][]{{"GlobalName", SampleTranscoder.OPERATION_NAME}, {"LocalName", SampleTranscoder.OPERATION_NAME}, {"Vendor", "Geotools 2"}, {"Description", "Transformation from sample to geophysics values"}, {"DocURL", "http://www.geotools.org/"}, {"Version", "1.0"}}, new String[]{"rendered"}, 1, new String[]{"sampleDimensions"}, new Class[]{array$Lorg$geotools$coverage$GridSampleDimension == null ? (array$Lorg$geotools$coverage$GridSampleDimension = SampleTranscoder.class$("[Lorg.geotools.coverage.GridSampleDimension;")) : array$Lorg$geotools$coverage$GridSampleDimension}, new Object[]{NO_PARAMETER_DEFAULT}, null);
        }

        protected boolean validateParameters(String modeName, ParameterBlock param, StringBuffer message) {
            if (!super.validateParameters(modeName, param, message)) {
                return false;
            }
            RenderedImage source = (RenderedImage)param.getSource(0);
            GridSampleDimension[] bands = (GridSampleDimension[])param.getObjectParameter(0);
            int numBands = source.getSampleModel().getNumBands();
            if (numBands != bands.length) {
                message.append(Resources.format(65, new Integer(numBands), new Integer(bands.length), "SampleDimension"));
                return false;
            }
            for (int i = 0; i < numBands; ++i) {
                if (bands[i].categories != null) continue;
                message.append(Resources.format(41, "sampleDimensions[" + i + "].categories", null));
                return false;
            }
            return true;
        }
    }
}

