/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import javax.media.jai.PropertySource;
import org.geotools.coverage.AbstractCoverage;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.FactoryFinder;
import org.geotools.resources.CRSUtilities;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.SampleDimension;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.Envelope;

public class TransformedCoverage
extends AbstractCoverage {
    private static final Hints HINTS = null;
    protected final Coverage coverage;
    private final MathTransform toWrapped;
    private final GeneralDirectPosition position;
    static /* synthetic */ Class class$org$geotools$coverage$TransformedCoverage;

    protected TransformedCoverage(CharSequence name, CoordinateReferenceSystem crs, Coverage coverage) throws FactoryException {
        super(name, crs, coverage instanceof PropertySource ? (PropertySource)coverage : null, null);
        this.coverage = coverage;
        this.position = new GeneralDirectPosition(crs.getCoordinateSystem().getDimension());
        this.toWrapped = FactoryFinder.getCoordinateOperationFactory(HINTS).createOperation(crs, coverage.getCoordinateReferenceSystem()).getMathTransform();
    }

    public static Coverage reproject(CharSequence name, CoordinateReferenceSystem crs, Coverage coverage) throws FactoryException {
        while (true) {
            if (CRSUtilities.equalsIgnoreMetadata(coverage.getCoordinateReferenceSystem(), crs)) {
                return coverage;
            }
            if (!(class$org$geotools$coverage$TransformedCoverage == null ? TransformedCoverage.class$("org.geotools.coverage.TransformedCoverage") : class$org$geotools$coverage$TransformedCoverage).equals(coverage.getClass())) break;
            coverage = ((TransformedCoverage)coverage).coverage;
        }
        return new TransformedCoverage(name, crs, coverage);
    }

    public int getNumSampleDimensions() {
        return this.coverage.getNumSampleDimensions();
    }

    public SampleDimension getSampleDimension(int index) throws IndexOutOfBoundsException {
        return this.coverage.getSampleDimension(index);
    }

    private final CannotEvaluateException transformationFailed(TransformException cause) {
        return new CannotEvaluateException("Transformation failed", (Throwable)cause);
    }

    public Envelope getEnvelope() {
        GeneralEnvelope envelope;
        try {
            envelope = CRSUtilities.transform(this.toWrapped.inverse(), this.coverage.getEnvelope());
        }
        catch (TransformException exception) {
            throw this.transformationFailed(exception);
        }
        envelope.setCoordinateReferenceSystem(this.crs);
        return envelope;
    }

    public final Object evaluate(DirectPosition coord) throws CannotEvaluateException {
        try {
            return this.coverage.evaluate(this.toWrapped.transform(coord, (DirectPosition)this.position));
        }
        catch (TransformException exception) {
            throw this.transformationFailed(exception);
        }
    }

    public final boolean[] evaluate(DirectPosition coord, boolean[] dest) throws CannotEvaluateException {
        try {
            return this.coverage.evaluate(this.toWrapped.transform(coord, (DirectPosition)this.position), dest);
        }
        catch (TransformException exception) {
            throw this.transformationFailed(exception);
        }
    }

    public final byte[] evaluate(DirectPosition coord, byte[] dest) throws CannotEvaluateException {
        try {
            return this.coverage.evaluate(this.toWrapped.transform(coord, (DirectPosition)this.position), dest);
        }
        catch (TransformException exception) {
            throw this.transformationFailed(exception);
        }
    }

    public final int[] evaluate(DirectPosition coord, int[] dest) throws CannotEvaluateException {
        try {
            return this.coverage.evaluate(this.toWrapped.transform(coord, (DirectPosition)this.position), dest);
        }
        catch (TransformException exception) {
            throw this.transformationFailed(exception);
        }
    }

    public final float[] evaluate(DirectPosition coord, float[] dest) throws CannotEvaluateException {
        try {
            return this.coverage.evaluate(this.toWrapped.transform(coord, (DirectPosition)this.position), dest);
        }
        catch (TransformException exception) {
            throw this.transformationFailed(exception);
        }
    }

    public final double[] evaluate(DirectPosition coord, double[] dest) throws CannotEvaluateException {
        try {
            return this.coverage.evaluate(this.toWrapped.transform(coord, (DirectPosition)this.position), dest);
        }
        catch (TransformException exception) {
            throw this.transformationFailed(exception);
        }
    }
}

