/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Color;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.LogRecord;
import javax.media.jai.ImageFunction;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertySource;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.remote.SerializableRenderedImage;
import javax.units.Unit;
import org.geotools.coverage.AbstractCoverage;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.AbstractGridCoverage;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.Grid2DSampleDimension;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.LookupTableFactory;
import org.geotools.coverage.grid.RenderedCoverage;
import org.geotools.coverage.processing.AbstractGridCoverageProcessor;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.resources.GCSUtilities;
import org.geotools.resources.XArray;
import org.geotools.resources.gcs.Resources;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.NumberRange;
import org.geotools.util.WeakHashSet;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.grid.GridRange;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class GridCoverage2D
extends AbstractGridCoverage
implements RenderedCoverage {
    private static final float EPS = 1.0E-5f;
    private static final boolean CONSERVATIVE_PIECEWISE = true;
    private static final AxisDirection[] IMAGE_ORIENTATION;
    private static final WeakHashSet pool;
    private transient GridCoverage2D inverse;
    private final CoordinateReferenceSystem crs2D;
    protected final transient PlanarImage image;
    private RenderedImage serializedImage;
    protected final GridGeometry2D gridGeometry;
    private final GeneralEnvelope envelope;
    private final GridSampleDimension[] sampleDimensions;
    private final boolean isGeophysics;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected GridCoverage2D(CharSequence name, GridCoverage2D coverage) {
        super(name, coverage);
        this.crs2D = coverage.crs2D;
        this.image = coverage.image;
        this.gridGeometry = coverage.gridGeometry;
        this.envelope = coverage.envelope;
        this.sampleDimensions = coverage.sampleDimensions;
        this.isGeophysics = coverage.isGeophysics;
    }

    public GridCoverage2D(CharSequence name, ImageFunction function, CoordinateReferenceSystem crs, GridGeometry2D gridGeometry, GridSampleDimension[] bands, Map properties) throws MismatchedDimensionException {
        this(name, GridCoverage2D.getImage(function, gridGeometry), crs, gridGeometry, null, bands, null, properties);
    }

    private static PlanarImage getImage(ImageFunction function, GridGeometry2D gridGeometry) {
        MathTransform2D transform = gridGeometry.getGridToCoordinateSystem2D();
        if (!(transform instanceof AffineTransform)) {
            throw new IllegalArgumentException(org.geotools.resources.cts.Resources.format(106));
        }
        AffineTransform at = (AffineTransform)transform;
        if (at.getShearX() != 0.0 || at.getShearY() != 0.0) {
            throw new IllegalArgumentException("Shear and rotation not supported");
        }
        double xScale = at.getScaleX();
        double yScale = at.getScaleY();
        double xTrans = -at.getTranslateX() / xScale;
        double yTrans = -at.getTranslateY() / yScale;
        GridRange range = gridGeometry.getGridRange();
        ParameterBlock param = new ParameterBlock().add(function).add(range.getLength(0)).add(range.getLength(1)).add((float)xScale).add((float)yScale).add((float)xTrans).add((float)yTrans);
        return JAI.create((String)"ImageFunction", (ParameterBlock)param);
    }

    public GridCoverage2D(CharSequence name, WritableRaster raster, Envelope envelope) throws MismatchedDimensionException {
        this(name, raster, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, envelope, null, null, null, (Color[][])null, null);
    }

    public GridCoverage2D(CharSequence name, WritableRaster raster, CoordinateReferenceSystem crs, Envelope envelope, double[] minValues, double[] maxValues, Unit units, Color[][] colors, RenderingHints hints) throws MismatchedDimensionException, IllegalArgumentException {
        this(name, raster, crs, null, new GeneralEnvelope(envelope), Grid2DSampleDimension.create(name, raster, minValues, maxValues, units, colors, hints));
    }

    public GridCoverage2D(CharSequence name, WritableRaster raster, CoordinateReferenceSystem crs, MathTransform gridToCRS, double[] minValues, double[] maxValues, Unit units, Color[][] colors, RenderingHints hints) throws MismatchedDimensionException, IllegalArgumentException {
        this(name, raster, crs, new GridGeometry2D(null, gridToCRS), null, Grid2DSampleDimension.create(name, raster, minValues, maxValues, units, colors, hints));
    }

    private GridCoverage2D(CharSequence name, WritableRaster raster, CoordinateReferenceSystem crs, GridGeometry2D gridGeometry, GeneralEnvelope envelope, GridSampleDimension[] bands) throws MismatchedDimensionException, IllegalArgumentException {
        this(name, PlanarImage.wrapRenderedImage((RenderedImage)new BufferedImage(bands[0].getColorModel(0, bands.length), raster, false, null)), crs, gridGeometry, envelope, bands, null, null);
    }

    public GridCoverage2D(CharSequence name, RenderedImage image, CoordinateReferenceSystem crs, Envelope envelope) throws MismatchedDimensionException {
        this(name, image, crs, envelope, null, null, null);
    }

    public GridCoverage2D(CharSequence name, RenderedImage image, CoordinateReferenceSystem crs, Envelope envelope, GridSampleDimension[] bands, GridCoverage[] sources, Map properties) throws MismatchedDimensionException, IllegalArgumentException {
        this(name, PlanarImage.wrapRenderedImage((RenderedImage)image), crs, null, new GeneralEnvelope(envelope), bands, sources, properties);
    }

    public GridCoverage2D(CharSequence name, RenderedImage image, CoordinateReferenceSystem crs, MathTransform gridToCRS, GridSampleDimension[] bands, GridCoverage[] sources, Map properties) throws MismatchedDimensionException, IllegalArgumentException {
        this(name, PlanarImage.wrapRenderedImage((RenderedImage)image), crs, new GridGeometry2D(null, gridToCRS), null, bands, sources, properties);
    }

    private GridCoverage2D(CharSequence name, PlanarImage image, CoordinateReferenceSystem crs, GridGeometry2D gridGeometry, GeneralEnvelope envelope, GridSampleDimension[] sdBands, GridCoverage[] sources, Map properties) throws MismatchedDimensionException, IllegalArgumentException {
        super(name, crs, sources, (PropertySource)image, properties);
        int dimension;
        GridRange gridRange;
        if (gridGeometry == null == (envelope == null)) {
            throw new AssertionError();
        }
        this.image = image;
        this.sampleDimensions = new GridSampleDimension[image.getNumBands()];
        this.isGeophysics = Grid2DSampleDimension.create(name, (RenderedImage)image, sdBands, this.sampleDimensions);
        CoordinateSystem cs = crs.getCoordinateSystem();
        if (GCSUtilities.hasGridRange(gridGeometry)) {
            gridRange = gridGeometry.getGridRange();
        } else {
            gridRange = new GeneralGridRange((RenderedImage)image, cs.getDimension());
            if (GCSUtilities.hasTransform(gridGeometry)) {
                gridGeometry = new GridGeometry2D(gridRange, gridGeometry.getGridToCoordinateSystem());
            }
        }
        if (gridGeometry != null) {
            String error = GridCoverage2D.checkConsistency((RenderedImage)image, gridGeometry);
            if (error != null) {
                throw new IllegalArgumentException(error);
            }
            if (envelope == null) {
                envelope = new GeneralEnvelope(gridGeometry.getEnvelope());
            }
        }
        if ((dimension = envelope.getDimension()) != cs.getDimension()) {
            throw new MismatchedDimensionException(org.geotools.resources.cts.Resources.format(98, new Integer(cs.getDimension()), new Integer(envelope.getDimension())));
        }
        envelope.setCoordinateReferenceSystem(crs);
        this.envelope = (GeneralEnvelope)pool.canonicalize(envelope);
        if (gridGeometry == null) {
            int i;
            boolean[] inverse = null;
            if (sources != null) {
                for (i = 0; i < sources.length; ++i) {
                    GridCoverage source = sources[i];
                    if (!(source instanceof GridCoverage2D)) continue;
                    boolean[] check = ((GridCoverage2D)source).gridGeometry.areAxisInverted();
                    check = XArray.resize(check, dimension);
                    if (inverse != null) {
                        if (Arrays.equals(check, inverse)) continue;
                        inverse = null;
                        break;
                    }
                    inverse = check;
                }
            }
            if (inverse == null) {
                inverse = new boolean[dimension];
                i = Math.min(IMAGE_ORIENTATION.length, dimension);
                while (--i >= 0) {
                    AxisDirection toInverse = IMAGE_ORIENTATION[i].opposite();
                    inverse[i] = toInverse.equals(cs.getAxis(1).getDirection());
                }
            }
            gridGeometry = new GridGeometry2D(gridRange, envelope, inverse);
        }
        this.gridGeometry = (GridGeometry2D)pool.canonicalize(gridGeometry);
        String error = GridCoverage2D.checkConsistency((RenderedImage)this.image, this.gridGeometry);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        if (dimension <= Math.max(gridGeometry.axisDimensionX, gridGeometry.axisDimensionY) || !(this.envelope.getLength(gridGeometry.axisDimensionX) > 0.0) || !(this.envelope.getLength(gridGeometry.axisDimensionY) > 0.0)) {
            throw new IllegalArgumentException(Resources.format(50));
        }
        try {
            this.crs2D = new FactoryGroup().separate(crs, new int[]{gridGeometry.axisDimensionX, gridGeometry.axisDimensionY});
        }
        catch (FactoryException exception) {
            IllegalArgumentException e = new IllegalArgumentException(org.geotools.resources.cts.Resources.format(82, "crs", crs.getName().getClass()));
            e.initCause(exception);
            throw e;
        }
        if (!$assertionsDisabled && this.crs2D.getCoordinateSystem().getDimension() != 2) {
            throw new AssertionError(this.crs2D);
        }
    }

    private static String checkConsistency(RenderedImage image, GridGeometry2D grid) {
        GridRange range = grid.getGridRange();
        int dimension = range.getDimension();
        for (int i = 0; i < dimension; ++i) {
            Object label;
            int length;
            int min;
            if (i == grid.gridDimensionX) {
                min = image.getMinX();
                length = image.getWidth();
                label = "\"X\"";
            } else if (i == grid.gridDimensionY) {
                min = image.getMinY();
                length = image.getHeight();
                label = "\"Y\"";
            } else {
                min = range.getLower(i);
                length = Math.min(Math.max(range.getUpper(i), 0), 1);
                label = new Integer(i);
            }
            if (range.getLower(i) == min && range.getLength(i) == length) continue;
            return Resources.format(40, label, new Integer(min), new Integer(min + length));
        }
        return null;
    }

    public boolean isDataEditable() {
        return this.image instanceof WritableRenderedImage;
    }

    public GridGeometry getGridGeometry() {
        String error = GridCoverage2D.checkConsistency((RenderedImage)this.image, this.gridGeometry);
        if (error != null) {
            throw new IllegalStateException(error);
        }
        return this.gridGeometry;
    }

    public Envelope getEnvelope() {
        return (Envelope)this.envelope.clone();
    }

    public Envelope2D getEnvelope2D() {
        return new Envelope2D(this.crs2D, this.envelope.getMinimum(this.gridGeometry.gridDimensionX), this.envelope.getMinimum(this.gridGeometry.gridDimensionY), this.envelope.getLength(this.gridGeometry.gridDimensionX), this.envelope.getLength(this.gridGeometry.gridDimensionY));
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem2D() {
        return this.crs2D;
    }

    public int getNumSampleDimensions() {
        return this.sampleDimensions.length;
    }

    public SampleDimension getSampleDimension(int index) {
        return this.sampleDimensions[index];
    }

    public GridSampleDimension[] getSampleDimensions() {
        return (GridSampleDimension[])this.sampleDimensions.clone();
    }

    public Interpolation getInterpolation() {
        return Interpolation.getInstance((int)0);
    }

    public Object evaluate(DirectPosition point) throws CannotEvaluateException {
        switch (this.image.getSampleModel().getDataType()) {
            case 0: {
                return this.evaluate(point, (byte[])null);
            }
            case 1: 
            case 2: 
            case 3: {
                return this.evaluate(point, (int[])null);
            }
            case 4: {
                return this.evaluate(point, (float[])null);
            }
            case 5: {
                return this.evaluate(point, (double[])null);
            }
        }
        throw new CannotEvaluateException();
    }

    public byte[] evaluate(DirectPosition coord, byte[] dest) throws CannotEvaluateException {
        int[] array = this.evaluate(coord, (int[])null);
        if (dest == null) {
            dest = new byte[array.length];
        }
        for (int i = 0; i < array.length; ++i) {
            dest[i] = (byte)array[i];
        }
        return dest;
    }

    public int[] evaluate(DirectPosition coord, int[] dest) throws CannotEvaluateException {
        return this.evaluate(this.toPoint2D(coord), dest);
    }

    public float[] evaluate(DirectPosition coord, float[] dest) throws CannotEvaluateException {
        return this.evaluate(this.toPoint2D(coord), dest);
    }

    public double[] evaluate(DirectPosition coord, double[] dest) throws CannotEvaluateException {
        return this.evaluate(this.toPoint2D(coord), dest);
    }

    private Point2D toPoint2D(DirectPosition point) throws MismatchedDimensionException {
        int expected;
        int actual = point.getDimension();
        if (actual != (expected = this.crs.getCoordinateSystem().getDimension())) {
            throw new MismatchedDimensionException(org.geotools.resources.cts.Resources.format(98, new Integer(actual), new Integer(expected)));
        }
        if (point instanceof Point2D) {
            return (Point2D)point;
        }
        return new Point2D.Double(point.getOrdinate(this.gridGeometry.axisDimensionX), point.getOrdinate(this.gridGeometry.axisDimensionY));
    }

    public int[] evaluate(Point2D coord, int[] dest) throws CannotEvaluateException {
        Point2D pixel = this.gridGeometry.inverseTransform(coord);
        double fx = pixel.getX();
        double fy = pixel.getY();
        if (!Double.isNaN(fx) && !Double.isNaN(fy)) {
            int x = (int)Math.round(fx);
            int y = (int)Math.round(fy);
            if (this.image.getBounds().contains(x, y)) {
                return this.image.getTile(this.image.XToTileX(x), this.image.YToTileY(y)).getPixel(x, y, dest);
            }
        }
        throw new PointOutsideCoverageException(this.pointOutsideCoverage(coord));
    }

    public float[] evaluate(Point2D coord, float[] dest) throws CannotEvaluateException {
        Point2D pixel = this.gridGeometry.inverseTransform(coord);
        double fx = pixel.getX();
        double fy = pixel.getY();
        if (!Double.isNaN(fx) && !Double.isNaN(fy)) {
            int x = (int)Math.round(fx);
            int y = (int)Math.round(fy);
            if (this.image.getBounds().contains(x, y)) {
                return this.image.getTile(this.image.XToTileX(x), this.image.YToTileY(y)).getPixel(x, y, dest);
            }
        }
        throw new PointOutsideCoverageException(this.pointOutsideCoverage(coord));
    }

    public double[] evaluate(Point2D coord, double[] dest) throws CannotEvaluateException {
        Point2D pixel = this.gridGeometry.inverseTransform(coord);
        double fx = pixel.getX();
        double fy = pixel.getY();
        if (!Double.isNaN(fx) && !Double.isNaN(fy)) {
            int x = (int)Math.round(fx);
            int y = (int)Math.round(fy);
            if (this.image.getBounds().contains(x, y)) {
                return this.image.getTile(this.image.XToTileX(x), this.image.YToTileY(y)).getPixel(x, y, dest);
            }
        }
        throw new PointOutsideCoverageException(this.pointOutsideCoverage(coord));
    }

    public synchronized String getDebugString(DirectPosition coord) {
        Point2D pixel = this.toPoint2D(coord);
        pixel = this.gridGeometry.inverseTransform(pixel);
        int x = (int)Math.round(pixel.getX());
        int y = (int)Math.round(pixel.getY());
        if (this.image.getBounds().contains(x, y)) {
            int numBands = this.image.getNumBands();
            Raster raster = this.image.getTile(this.image.XToTileX(x), this.image.YToTileY(y));
            int datatype = this.image.getSampleModel().getDataType();
            StringBuffer buffer = new StringBuffer();
            buffer.append('(');
            buffer.append(x);
            buffer.append(',');
            buffer.append(y);
            buffer.append(")=[");
            for (int band = 0; band < numBands; ++band) {
                if (band != 0) {
                    buffer.append(";\u00a0");
                }
                double sample = raster.getSampleDouble(x, y, band);
                switch (datatype) {
                    case 5: {
                        buffer.append(sample);
                        break;
                    }
                    case 4: {
                        buffer.append((float)sample);
                        break;
                    }
                    default: {
                        buffer.append((int)sample);
                    }
                }
                String formatted = this.sampleDimensions[band].getLabel(sample, null);
                if (formatted == null) continue;
                buffer.append("\u00a0(");
                buffer.append(formatted);
                buffer.append(')');
            }
            buffer.append(']');
            return buffer.toString();
        }
        return null;
    }

    public int[] getOptimalDataBlockSizes() {
        int[] size = new int[this.getDimension()];
        Arrays.fill(size, 1);
        size[this.gridGeometry.gridDimensionX] = this.image.getTileWidth();
        size[this.gridGeometry.gridDimensionY] = this.image.getTileHeight();
        return size;
    }

    public RenderedImage getRenderedImage() {
        return this.image;
    }

    public RenderableImage getRenderableImage(int xAxis, int yAxis) {
        if (xAxis == this.gridGeometry.axisDimensionX && yAxis == this.gridGeometry.axisDimensionY) {
            return new Renderable();
        }
        return super.getRenderableImage(xAxis, yAxis);
    }

    public void show() {
        this.show(this.gridGeometry.axisDimensionX, this.gridGeometry.axisDimensionY);
    }

    public void prefetch(Rectangle2D area) {
        Point[] tileIndices = this.image.getTileIndices(this.gridGeometry.inverseTransform(area));
        if (tileIndices != null) {
            this.image.prefetchTiles(tileIndices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage2D geophysics(boolean geo) {
        if (geo == this.isGeophysics) {
            return this;
        }
        if (this.inverse != null) {
            return this.inverse;
        }
        if (!GCSUtilities.hasTransform(this.sampleDimensions)) {
            this.inverse = this;
            return this.inverse;
        }
        GridCoverage2D gridCoverage2D = this;
        synchronized (gridCoverage2D) {
            this.inverse = this.createGeophysics(geo);
            if (this.inverse.inverse == null) {
                this.inverse.inverse = this;
            } else if (this.inverse.inverse != this) {
                Locale locale = this.getLocale();
                throw new RasterFormatException(Resources.getResources(locale).getString(49, "geophysics", this.inverse.inverse.getName().toString(locale)));
            }
            return this.inverse;
        }
    }

    protected GridCoverage2D createGeophysics(boolean geo) {
        NullOpImage op;
        PlanarImage image = this.image;
        while (image instanceof NullOpImage && (op = (NullOpImage)image).getNumSources() == 1) {
            image = op.getSourceImage(0);
        }
        int numBands = image.getNumBands();
        int visibleBand = GCSUtilities.getVisibleBand((RenderedImage)image);
        GridSampleDimension[] targetBands = (GridSampleDimension[])this.sampleDimensions.clone();
        if (!$assertionsDisabled && targetBands.length != numBands) {
            throw new AssertionError(targetBands.length);
        }
        for (int i = 0; i < targetBands.length; ++i) {
            targetBands[i] = targetBands[i].geophysics(geo);
        }
        ImageLayout layout = ImageUtilities.getImageLayout((RenderedImage)image);
        ColorModel colors = targetBands[visibleBand].getColorModel(visibleBand, numBands);
        SampleModel model = colors.createCompatibleSampleModel(layout.getTileWidth((RenderedImage)image), layout.getTileHeight((RenderedImage)image));
        if (colors instanceof IndexColorModel && model.getClass().equals(ComponentSampleModel.class)) {
            int w = model.getWidth();
            int h = model.getHeight();
            model = new PixelInterleavedSampleModel(colors.getTransferType(), w, h, 1, w, new int[1]);
        }
        layout = layout.setSampleModel(model).setColorModel(colors);
        ParameterBlock param = new ParameterBlock().addSource(image);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        hints.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        String operation = null;
        try {
            int sourceType = image.getSampleModel().getDataType();
            int targetType = model.getDataType();
            MathTransform1D[] transforms = new MathTransform1D[numBands];
            for (int i = 0; i < numBands; ++i) {
                transforms[i] = this.sampleDimensions[i].geophysics(false).getSampleToGeophysics();
                if (transforms[i] == null || geo) continue;
                transforms[i] = (MathTransform1D)transforms[i].inverse();
            }
            LookupTableJAI table = LookupTableFactory.create(sourceType, targetType, transforms);
            if (table != null) {
                operation = "Lookup";
                param = param.add(table);
            }
        }
        catch (TransformException exception) {
            // empty catch block
        }
        if (operation == null) {
            try {
                boolean canRescale = true;
                boolean canPiecewise = true;
                double[] scales = null;
                double[] offsets = null;
                Object breakpoints = null;
                block7: for (int i = 0; i < numBands; ++i) {
                    GridSampleDimension sd = this.sampleDimensions[i];
                    List categories = sd.getCategories();
                    int numCategories = categories.size();
                    float[] sourceBreakpoints = null;
                    float[] targetBreakpoints = null;
                    double expectedSource = Double.NaN;
                    double expectedTarget = Double.NaN;
                    int jbp = 0;
                    for (int j = 0; j < numCategories; ++j) {
                        Category category = (Category)categories.get(j);
                        MathTransform1D transform = category.geophysics(false).getSampleToGeophysics();
                        if (transform == null) {
                            canPiecewise = false;
                            canRescale = false;
                            break block7;
                        }
                        if (!geo) {
                            transform = (MathTransform1D)transform.inverse();
                        }
                        double offset = transform.transform(0.0);
                        double scale = transform.derivative(Double.NaN);
                        if (Double.isNaN(scale) || Double.isNaN(offset)) {
                            canRescale = false;
                            canPiecewise = false;
                            break block7;
                        }
                        if (j == 0) {
                            if (i == 0) {
                                scales = new double[numBands];
                                offsets = new double[numBands];
                                breakpoints = new float[numBands][][];
                            }
                            sourceBreakpoints = new float[numCategories * 2];
                            targetBreakpoints = new float[numCategories * 2];
                            breakpoints[i] = new float[][]{sourceBreakpoints, targetBreakpoints};
                            offsets[i] = offset;
                            scales[i] = scale;
                        }
                        if (offset != offsets[i] || scale != scales[i]) {
                            canRescale = false;
                        }
                        NumberRange range = category.getRange();
                        double minimum = range.getMinimum(true);
                        double maximum = range.getMaximum(true);
                        float sourceMin = (float)minimum;
                        float sourceMax = (float)maximum;
                        float targetMin = (float)(minimum * scale + offset);
                        float targetMax = (float)(maximum * scale + offset);
                        if (!$assertionsDisabled && !(sourceMin <= sourceMax)) {
                            throw new AssertionError((Object)range);
                        }
                        if (Math.abs(minimum - expectedSource) <= (double)1.0E-5f) {
                            if (Math.abs((double)targetMin - expectedTarget) <= (double)1.0E-5f) {
                                --jbp;
                            } else {
                                if (!$assertionsDisabled && !(sourceBreakpoints[jbp - 1] < sourceMin)) {
                                    throw new AssertionError(expectedSource);
                                }
                                canPiecewise = false;
                            }
                        } else if (j != 0) {
                            if (!$assertionsDisabled && expectedSource > (double)sourceMin) {
                                throw new AssertionError(expectedSource);
                            }
                            canPiecewise = false;
                        }
                        sourceBreakpoints[jbp] = sourceMin;
                        sourceBreakpoints[jbp + 1] = sourceMax;
                        targetBreakpoints[jbp] = targetMin;
                        targetBreakpoints[jbp + 1] = targetMax;
                        jbp += 2;
                        expectedSource = range.getMaximum(false);
                        expectedTarget = expectedSource * scale + offset;
                    }
                    canPiecewise = false;
                }
                if (canRescale && scales != null) {
                    operation = "Rescale";
                    param = param.add(scales).add(offsets);
                } else if (canPiecewise && breakpoints != null) {
                    operation = "Piecewise";
                    param = param.add(breakpoints);
                }
            }
            catch (TransformException exception) {
                // empty catch block
            }
        }
        if (operation == null) {
            param = param.add(this.sampleDimensions);
            operation = "org.geotools.SampleTranscode";
        }
        if (LOGGER.isLoggable(AbstractGridCoverageProcessor.OPERATION)) {
            int index = operation.lastIndexOf(46);
            String shortName = index >= 0 ? operation.substring(index + 1) : operation;
            Locale locale = this.getLocale();
            LogRecord record = Resources.getResources(locale).getLogRecord(AbstractGridCoverageProcessor.OPERATION, 26, new Object[]{this.getName().toString(locale), new Integer(geo ? 1 : 0), shortName});
            record.setSourceClassName("GridCoverage");
            record.setSourceMethodName("geophysics");
            LOGGER.log(record);
        }
        return new GridCoverage2D((CharSequence)this.getName(), (PlanarImage)JAI.create((String)operation, (ParameterBlock)param, (RenderingHints)hints), this.crs, this.gridGeometry, null, targetBands, new GridCoverage[]{this}, null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Field field = GridCoverage2D.class.getDeclaredField("image");
            field.setAccessible(true);
            field.set(this, PlanarImage.wrapRenderedImage((RenderedImage)this.serializedImage));
        }
        catch (NoSuchFieldException cause) {
            InvalidClassException e = new InvalidClassException(cause.getLocalizedMessage());
            e.initCause(cause);
            throw e;
        }
        catch (IllegalAccessException cause) {
            InvalidObjectException e = new InvalidObjectException(cause.getLocalizedMessage());
            e.initCause(cause);
            throw e;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.serializedImage == null) {
            Object source = this.image;
            while (source instanceof RenderedImageAdapter) {
                source = ((RenderedImageAdapter)source).getWrappedImage();
            }
            this.serializedImage = source instanceof SerializableRenderedImage ? (SerializableRenderedImage)source : new SerializableRenderedImage((RenderedImage)source, false, null, "gzip", null, null);
        }
        out.defaultWriteObject();
    }

    static {
        $assertionsDisabled = !GridCoverage2D.class.desiredAssertionStatus();
        IMAGE_ORIENTATION = new AxisDirection[]{AxisDirection.EAST, AxisDirection.SOUTH};
        pool = new WeakHashSet();
    }

    protected class Renderable
    extends AbstractCoverage.Renderable {
        public Renderable() {
            super(GridCoverage2D.this, GridCoverage2D.this.gridGeometry.axisDimensionX, GridCoverage2D.this.gridGeometry.axisDimensionY);
        }

        public RenderedImage createDefaultRendering() {
            if (this.xAxis == GridCoverage2D.this.gridGeometry.axisDimensionX && this.yAxis == GridCoverage2D.this.gridGeometry.axisDimensionY) {
                return GridCoverage2D.this.getRenderedImage();
            }
            return super.createDefaultRendering();
        }
    }
}

