/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.media.jai.PropertySource;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.AbstractGridCoverage;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.RenderedCoverage;
import org.geotools.util.SimpleInternationalString;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.grid.GridNotEditableException;
import org.opengis.coverage.grid.GridPacking;
import org.opengis.coverage.grid.GridRange;
import org.opengis.coverage.grid.InvalidRangeException;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.util.InternationalString;

public class GridCoverageImpl
extends AbstractGridCoverage
implements RenderedCoverage {
    private static final long serialVersionUID = 1L;
    private BufferedImage image;
    private MathTransform transform;
    private Envelope envelope;

    public GridCoverageImpl(AbstractGridCoverage coverage) throws OperationNotFoundException, NoSuchElementException, FactoryException {
        super((CharSequence)null, coverage);
    }

    public GridCoverageImpl(String name, CoordinateReferenceSystem crs, PropertySource source, Map properties, BufferedImage image, Envelope envelope) throws OperationNotFoundException, NoSuchElementException, FactoryException {
        super(name, crs, source, properties);
        this.image = image;
        this.envelope = envelope;
    }

    public boolean isDataEditable() {
        return this.image.isTileWritable(0, 0);
    }

    public GridPacking getGridPacking() {
        return null;
    }

    public GridGeometry getGridGeometry() {
        GeneralGridRange range = new GeneralGridRange(this.image);
        boolean[] inverse = new boolean[]{false, false};
        return new GeneralGridGeometry(range, this.envelope, inverse);
    }

    public int[] getOptimalDataBlockSizes() {
        return this.image.getRaster().getSampleModel().getSampleSize();
    }

    public int getNumOverviews() {
        return 0;
    }

    public GridGeometry getOverviewGridGeometry(int arg0) throws IndexOutOfBoundsException {
        return null;
    }

    public GridCoverage getOverview(int arg0) throws IndexOutOfBoundsException {
        return null;
    }

    public boolean[] getDataBlock(GridRange range, boolean[] destination) throws InvalidRangeException, ArrayIndexOutOfBoundsException {
        if (destination == null) {
            destination = new boolean[range.getLength(0) + range.getLength(1)];
        }
        int[] temp = new int[range.getLength(0) + range.getLength(1)];
        this.image.getRaster().getPixels(range.getLower(0), range.getLower(1), range.getLength(0), range.getLength(1), temp);
        for (int i = 0; i < temp.length; ++i) {
            destination[i] = temp[i] == 0;
        }
        return destination;
    }

    public byte[] getDataBlock(GridRange range, byte[] destination) throws InvalidRangeException, ArrayIndexOutOfBoundsException {
        if (destination == null) {
            destination = new byte[range.getLength(0) + range.getLength(1)];
        }
        int[] temp = new int[range.getLength(0) + range.getLength(1)];
        this.image.getRaster().getPixels(range.getLower(0), range.getLower(1), range.getLength(0), range.getLength(1), temp);
        for (int i = 0; i < temp.length; ++i) {
            destination[i] = (byte)temp[i];
        }
        return destination;
    }

    public short[] getDataBlock(GridRange range, short[] destination) throws InvalidRangeException, ArrayIndexOutOfBoundsException {
        if (destination == null) {
            destination = new short[range.getLength(0) + range.getLength(1)];
        }
        int[] temp = new int[range.getLength(0) + range.getLength(1)];
        this.image.getRaster().getPixels(range.getLower(0), range.getLower(1), range.getLength(0), range.getLength(1), temp);
        for (int i = 0; i < temp.length; ++i) {
            destination[i] = (short)temp[i];
        }
        return destination;
    }

    public int[] getDataBlock(GridRange range, int[] destination) throws InvalidRangeException, ArrayIndexOutOfBoundsException {
        if (destination == null) {
            destination = new int[range.getLength(0) + range.getLength(1)];
        }
        int[] temp = new int[range.getLength(0) + range.getLength(1)];
        this.image.getRaster().getPixels(range.getLower(0), range.getLower(1), range.getLength(0), range.getLength(1), temp);
        for (int i = 0; i < temp.length; ++i) {
            destination[i] = temp[i];
        }
        return destination;
    }

    public float[] getDataBlock(GridRange range, float[] destination) throws InvalidRangeException, ArrayIndexOutOfBoundsException {
        if (destination == null) {
            destination = new float[range.getLength(0) + range.getLength(1)];
        }
        float[] temp = new float[range.getLength(0) + range.getLength(1)];
        this.image.getRaster().getPixels(range.getLower(0), range.getLower(1), range.getLength(0), range.getLength(1), temp);
        for (int i = 0; i < temp.length; ++i) {
            destination[i] = temp[i];
        }
        return destination;
    }

    public double[] getDataBlock(GridRange range, double[] destination) throws InvalidRangeException, ArrayIndexOutOfBoundsException {
        if (destination == null) {
            destination = new double[range.getLength(0) + range.getLength(1)];
        }
        double[] temp = new double[range.getLength(0) + range.getLength(1)];
        this.image.getRaster().getPixels(range.getLower(0), range.getLower(1), range.getLength(0), range.getLength(1), temp);
        for (int i = 0; i < temp.length; ++i) {
            destination[i] = temp[i];
        }
        return destination;
    }

    public byte[] getPackedDataBlock(GridRange arg0) throws InvalidRangeException {
        return null;
    }

    public void setDataBlock(GridRange range, boolean[] values) throws InvalidRangeException, GridNotEditableException, ArrayIndexOutOfBoundsException {
        int[] temp = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            temp[i] = values[i] ? 1 : 0;
        }
        this.image.getRaster().setPixels(range.getLower(0), range.getLower(1), range.getLength(0), range.getLength(1), temp);
    }

    public void setDataBlock(GridRange range, byte[] values) throws InvalidRangeException, GridNotEditableException, ArrayIndexOutOfBoundsException {
        int[] temp = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            temp[i] = values[i];
        }
        this.image.getRaster().setPixels(range.getLower(0), range.getLower(1), range.getLength(0), range.getLength(1), temp);
    }

    public void setDataBlock(GridRange range, short[] values) throws InvalidRangeException, GridNotEditableException, ArrayIndexOutOfBoundsException {
        int[] temp = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            temp[i] = values[i];
        }
        this.image.getRaster().setPixels(range.getLower(0), range.getLower(1), range.getLength(0), range.getLength(1), temp);
    }

    public void setDataBlock(GridRange range, int[] values) throws InvalidRangeException, GridNotEditableException, ArrayIndexOutOfBoundsException {
        this.image.getRaster().setPixels(range.getLower(0), range.getLower(1), range.getLength(0), range.getLength(1), values);
    }

    public void setDataBlock(GridRange range, float[] values) throws InvalidRangeException, GridNotEditableException, ArrayIndexOutOfBoundsException {
        this.image.getRaster().setPixels(range.getLower(0), range.getLower(1), range.getLength(0), range.getLength(1), values);
    }

    public void setDataBlock(GridRange range, double[] values) throws InvalidRangeException, GridNotEditableException, ArrayIndexOutOfBoundsException {
        this.image.getRaster().setPixels(range.getLower(0), range.getLower(1), range.getLength(0), range.getLength(1), values);
    }

    public void setPackedDataBlock(GridRange arg0, byte[] arg1) throws InvalidRangeException, GridNotEditableException, ArrayIndexOutOfBoundsException {
    }

    public InternationalString[] getDimensionNames() {
        ArrayList results = new ArrayList();
        results.addAll(this.crs.getCoordinateSystem().getAxis(0).getIdentifiers());
        results.addAll(this.crs.getCoordinateSystem().getAxis(1).getIdentifiers());
        InternationalString[] strings = new InternationalString[results.size()];
        for (int i = 0; i < results.size(); ++i) {
            Identifier identifier = (Identifier)results.get(i);
            strings[i] = new SimpleInternationalString(identifier.getCode());
        }
        return strings;
    }

    public int getNumSampleDimensions() {
        return this.image.getRaster().getNumBands();
    }

    public SampleDimension getSampleDimension(int index) throws IndexOutOfBoundsException {
        return new GridSampleDimension(new String[]{"Alpha", "Red", "Green", "Blue"}, new Color[]{new Color(0, 0, 0, 0), Color.RED, Color.GREEN, Color.BLUE});
    }

    public List getSources() {
        return Collections.singletonList(this);
    }

    public Object evaluate(DirectPosition point) throws CannotEvaluateException {
        double[] results = new double[2];
        DirectPosition transformedPoint = (DirectPosition)point.clone();
        try {
            if (point.getCoordinateReferenceSystem().equals(this.crs)) {
                this.transform.transform(point, transformedPoint);
            }
        }
        catch (Exception e) {
            throw new CannotEvaluateException("Exception occured while transforming.", (Throwable)e);
        }
        this.image.getRaster().getPixel((int)point.getCoordinates()[0], (int)point.getCoordinates()[1], results);
        return results;
    }

    public RenderedImage getRenderedImage() {
        return this.image;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(Envelope envelope) {
        this.envelope = envelope;
    }
}

