/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.RenderingHints;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.GridCoverageProcessor2D;
import org.geotools.factory.Hints;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.resources.Utilities;
import org.geotools.util.NumberRange;
import org.opengis.coverage.processing.Operation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.InternationalString;

public abstract class Operation2D
implements Operation,
Serializable {
    private static final long serialVersionUID = 574096338873406394L;
    public static final ParameterDescriptor SOURCE_0;
    static final Integer ZERO;
    static final Integer ONE;
    static final Integer TWO;
    static final Integer THREE;
    static final NumberRange RANGE_0;
    static final NumberRange RANGE_1;
    protected final ParameterDescriptorGroup descriptor;
    static /* synthetic */ Class class$org$opengis$coverage$grid$GridCoverage;

    public Operation2D(ParameterDescriptorGroup descriptor) {
        this.descriptor = descriptor;
    }

    public String getName() {
        return this.descriptor.getName().getCode();
    }

    public String getDescription() {
        InternationalString remarks = this.descriptor.getRemarks();
        return remarks != null ? remarks.toString() : null;
    }

    public String getDocURL() {
        return null;
    }

    public String getVersion() {
        return this.descriptor.getName().getVersion();
    }

    public String getVendor() {
        return "Geotools 2";
    }

    public int getNumSources() {
        return Operation2D.getNumSources(this.descriptor);
    }

    private static int getNumSources(ParameterDescriptorGroup descriptor) {
        int count = 0;
        Iterator it = descriptor.descriptors().iterator();
        while (it.hasNext()) {
            Class type;
            GeneralParameterDescriptor candidate = (GeneralParameterDescriptor)it.next();
            if (candidate instanceof ParameterDescriptorGroup) {
                count += Operation2D.getNumSources((ParameterDescriptorGroup)candidate);
                continue;
            }
            if (!(candidate instanceof ParameterDescriptor) || !(class$org$opengis$coverage$grid$GridCoverage == null ? Operation2D.class$("org.opengis.coverage.grid.GridCoverage") : class$org$opengis$coverage$grid$GridCoverage).isAssignableFrom(type = ((ParameterDescriptor)candidate).getValueClass())) continue;
            ++count;
        }
        return count;
    }

    public ParameterValueGroup getParameters() {
        return (ParameterValueGroup)this.descriptor.createValue();
    }

    protected abstract GridCoverage2D doOperation(ParameterValueGroup var1, RenderingHints var2);

    protected static GridCoverageProcessor2D getGridCoverageProcessor(RenderingHints hints) {
        Object value;
        if (hints != null && (value = hints.get(Hints.GRID_COVERAGE_PROCESSOR)) instanceof GridCoverageProcessor2D) {
            return (GridCoverageProcessor2D)((Object)value);
        }
        return GridCoverageProcessor2D.getDefault();
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            Operation2D that = (Operation2D)object;
            return Utilities.equals(this.descriptor, that.descriptor);
        }
        return false;
    }

    public String toString() {
        return Utilities.getShortClassName(this) + '[' + this.getName() + ']';
    }

    static {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("name", "Source");
        properties.put("alias", "source0");
        SOURCE_0 = new DefaultParameterDescriptor(properties, GridCoverage2D.class, null, null, null, null, null, true);
        ZERO = new Integer(0);
        ONE = new Integer(1);
        TWO = new Integer(2);
        THREE = new Integer(3);
        RANGE_0 = new NumberRange(Integer.class, ZERO, null);
        RANGE_1 = new NumberRange(Integer.class, ONE, null);
    }
}

