/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultFeatureResults;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.Filter;

public abstract class AbstractFeatureSource
implements FeatureSource {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data");

    public Transaction getTransaction() {
        return Transaction.AUTO_COMMIT;
    }

    public FeatureCollection getFeatures(Query query) {
        return new DefaultFeatureResults(this, query);
    }

    public FeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new DefaultQuery(this.getSchema().getTypeName(), filter));
    }

    public FeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Filter.NONE);
    }

    public Envelope getBounds() throws IOException {
        return this.getBounds(this.getSchema() == null ? Query.ALL : new DefaultQuery(this.getSchema().getTypeName()));
    }

    public Envelope getBounds(Query query) throws IOException {
        if (query.getFilter() == Filter.ALL) {
            return new Envelope();
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null || !(dataStore instanceof AbstractDataStore)) {
            return null;
        }
        return ((AbstractDataStore)dataStore).getBounds(this.namedQuery(query));
    }

    protected Query namedQuery(Query query) {
        String typeName = this.getSchema().getTypeName();
        if (query.getTypeName() == null || !query.getTypeName().equals(typeName)) {
            return new DefaultQuery(typeName, query.getFilter(), query.getMaxFeatures(), query.getPropertyNames(), query.getHandle());
        }
        return query;
    }

    public int getCount(Query query) throws IOException {
        if (query.getFilter() == Filter.ALL) {
            return 0;
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null || !(dataStore instanceof AbstractDataStore)) {
            return -1;
        }
        Transaction t = this.getTransaction();
        int delta = 0;
        if (t != Transaction.AUTO_COMMIT) {
            Map diff = ((AbstractDataStore)dataStore).state(t).diff(this.namedQuery(query).getTypeName());
            Iterator it = diff.keySet().iterator();
            HashSet newFIDs = new HashSet();
            while (it.hasNext()) {
                Object fid = it.next();
                if (fid.toString().startsWith("new")) {
                    if (!newFIDs.add(fid)) continue;
                    ++delta;
                    continue;
                }
                if (diff.get(fid) != null) continue;
                --delta;
            }
        }
        return ((AbstractDataStore)dataStore).getCount(this.namedQuery(query)) + delta;
    }
}

