/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.factory.FactoryFinder;

public final class DataStoreFinder {
    protected static final Logger LOGGER = Logger.getLogger("org.geotools.data");

    private DataStoreFinder() {
    }

    public static DataStore getDataStore(Map params) throws IOException {
        Iterator ps = DataStoreFinder.getAvailableDataStores();
        while (ps.hasNext()) {
            DataStoreFactorySpi fac = (DataStoreFactorySpi)ps.next();
            try {
                if (!fac.canProcess(params)) continue;
                return fac.createDataStore(params);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Could not aquire " + fac.getDescription() + ":" + t, t);
            }
        }
        return null;
    }

    public static Iterator getAvailableDataStores() {
        HashSet<DataStoreFactorySpi> availableDS = new HashSet<DataStoreFactorySpi>();
        Iterator it = FactoryFinder.factories(DataStoreFactorySpi.class);
        while (it.hasNext()) {
            DataStoreFactorySpi dsFactory = (DataStoreFactorySpi)it.next();
            if (!dsFactory.isAvailable()) continue;
            availableDS.add(dsFactory);
        }
        return availableDS.iterator();
    }
}

