/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.AttributeReader;
import org.geotools.data.FeatureReader;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;

public class DefaultFeatureReader
implements FeatureReader {
    private final AttributeReader attributeReader;
    private final FeatureType schema;
    protected final Object[] attributes;

    public DefaultFeatureReader(AttributeReader attributeReader, FeatureType schema) throws SchemaException {
        this.attributeReader = attributeReader;
        if (schema == null) {
            schema = this.createSchema();
        }
        this.schema = schema;
        this.attributes = new Object[attributeReader.getAttributeCount()];
    }

    public DefaultFeatureReader(AttributeReader attributeReader) throws SchemaException {
        this(attributeReader, null);
    }

    public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        Feature f = null;
        if (this.attributeReader.hasNext()) {
            this.attributeReader.next();
            f = this.readFeature(this.attributeReader);
        }
        return f;
    }

    protected FeatureType createSchema() throws SchemaException {
        FeatureTypeFactory factory = FeatureTypeFactory.newInstance("xxx");
        int ii = this.attributeReader.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            factory.addType(this.attributeReader.getAttributeType(i));
        }
        return factory.getFeatureType();
    }

    protected Feature readFeature(AttributeReader atts) throws IllegalAttributeException, IOException {
        int ii = atts.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            this.attributes[i] = atts.read(i);
        }
        return this.schema.create(this.attributes);
    }

    public void close() throws IOException {
        this.attributeReader.close();
    }

    public FeatureType getFeatureType() {
        return this.schema;
    }

    public boolean hasNext() throws IOException {
        return this.attributeReader.hasNext();
    }
}

