/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.LockingManager;
import org.geotools.data.Repository;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureType;

public class DefaultRepository
implements Repository {
    protected SortedMap datastores = new TreeMap();

    private static final Map definition(String definition) throws ParseException {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] params = definition.split(",");
        int offset = 0;
        for (int i = 0; i < params.length; ++i) {
            String[] vals = params[i].split("=");
            if (vals.length != 2) {
                throw new ParseException("Could not interpret " + params[i], offset);
            }
            map.put(vals[0].trim(), vals[1].trim());
            offset += params[i].length();
        }
        return map;
    }

    public void load(File propertiesFile) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(propertiesFile));
        Iterator<Map.Entry<Object, Object>> i = properties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            String dataStoreId = (String)entry.getKey();
            String definition = (String)entry.getValue();
            Map params = DefaultRepository.definition(definition);
            DataStore dataStore = DataStoreFinder.getDataStore(params);
            this.register(dataStoreId, dataStore);
        }
    }

    public SortedMap getFeatureSources() {
        TreeMap<String, FeatureSource> map = new TreeMap<String, FeatureSource>();
        Iterator i = this.datastores.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String id = (String)entry.getKey();
            DataStore ds = (DataStore)entry.getValue();
            try {
                String[] typeNames = ds.getTypeNames();
                for (int j = 0; j < typeNames.length; ++j) {
                    String typeName = typeNames[j];
                    try {
                        map.put(id + ":" + typeName, ds.getFeatureSource(typeName));
                        continue;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            catch (IOException e1) {
            }
        }
        return map;
    }

    public Set getPrefixes() throws IOException {
        HashSet<String> prefix = new HashSet<String>();
        Iterator i = this.datastores.values().iterator();
        while (i.hasNext()) {
            DataStore ds = (DataStore)i.next();
            Iterator t = this.types(ds).values().iterator();
            while (t.hasNext()) {
                FeatureType schema = (FeatureType)t.next();
                prefix.add(schema.getNamespace().toString());
            }
        }
        return prefix;
    }

    private SortedSet typeNames(DataStore ds) throws IOException {
        return new TreeSet<String>(Arrays.asList(ds.getTypeNames()));
    }

    private SortedMap types(DataStore ds) throws IOException {
        TreeMap<String, FeatureType> map = new TreeMap<String, FeatureType>();
        String[] typeNames = ds.getTypeNames();
        for (int i = 0; i < typeNames.length; ++i) {
            try {
                map.put(typeNames[i], ds.getSchema(typeNames[i]));
                continue;
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return map;
    }

    public SortedMap types() throws IOException {
        TreeMap<String, FeatureType> map = new TreeMap<String, FeatureType>();
        Iterator i = this.datastores.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String id = (String)entry.getKey();
            DataStore ds = (DataStore)entry.getValue();
            Iterator t = this.types(ds).values().iterator();
            while (t.hasNext()) {
                FeatureType schema = (FeatureType)t.next();
                map.put(id + ":" + schema.getTypeName(), schema);
            }
        }
        return map;
    }

    public boolean lockExists(String lockID) {
        if (lockID == null) {
            return false;
        }
        Iterator i = this.datastores.values().iterator();
        while (i.hasNext()) {
            DataStore store = (DataStore)i.next();
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.exists(lockID)) continue;
            return true;
        }
        return false;
    }

    public boolean lockRefresh(String lockID, Transaction transaction) throws IOException {
        if (lockID == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + lockID + ")");
        }
        boolean refresh = false;
        Iterator i = this.datastores.values().iterator();
        while (i.hasNext()) {
            DataStore store = (DataStore)i.next();
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.release(lockID, transaction)) continue;
            refresh = true;
        }
        return refresh;
    }

    public boolean lockRelease(String lockID, Transaction transaction) throws IOException {
        if (lockID == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + lockID + ")");
        }
        boolean release = false;
        Iterator i = this.datastores.values().iterator();
        while (i.hasNext()) {
            DataStore store = (DataStore)i.next();
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.release(lockID, transaction)) continue;
            release = true;
        }
        return release;
    }

    public void register(String id, DataStore dataStore) throws IOException {
        if (this.datastores.containsKey(id)) {
            throw new IOException("ID already registered");
        }
        if (this.datastores.containsValue(dataStore)) {
            throw new IOException("dataStore already registered");
        }
        this.datastores.put(id, dataStore);
    }

    public DataStore datastore(String id) {
        return (DataStore)this.datastores.get(id);
    }

    public Map getDataStores() {
        return Collections.unmodifiableMap(this.datastores);
    }

    public FeatureSource source(String dataStoreId, String typeName) throws IOException {
        DataStore ds = this.datastore(dataStoreId);
        return ds.getFeatureSource(typeName);
    }
}

