/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

public class ReTypeFeatureReader
implements FeatureReader {
    FeatureReader reader;
    FeatureType featureType;
    AttributeType[] types;

    public ReTypeFeatureReader(FeatureReader reader, FeatureType featureType) {
        this.reader = reader;
        this.featureType = featureType;
        this.types = this.typeAttributes(featureType, reader.getFeatureType());
    }

    protected AttributeType[] typeAttributes(FeatureType target, FeatureType origional) {
        if (((Object)target).equals(origional)) {
            throw new IllegalArgumentException("FeatureReader allready produces contents with the correct schema");
        }
        if (target.getAttributeCount() > origional.getAttributeCount()) {
            throw new IllegalArgumentException("Unable to retype FeatureReader (origional does not cover requested type)");
        }
        AttributeType[] types = new AttributeType[target.getAttributeCount()];
        for (int i = 0; i < target.getAttributeCount(); ++i) {
            AttributeType attrib = target.getAttributeType(i);
            String xpath = attrib.getName();
            types[i] = attrib;
            if (attrib.equals(origional.getAttributeType(xpath))) continue;
            throw new IllegalArgumentException("Unable to retype FeatureReader (origional does not cover " + xpath + ")");
        }
        return types;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.reader == null) {
            throw new IOException("FeatureReader has been closed");
        }
        Feature next = this.reader.next();
        String id = next.getID();
        Object[] attributes = new Object[this.types.length];
        for (int i = 0; i < this.types.length; ++i) {
            String xpath = this.types[i].getName();
            attributes[i] = this.types[i].duplicate(next.getAttribute(xpath));
        }
        return this.featureType.create(attributes, id);
    }

    public boolean hasNext() throws IOException {
        return this.reader.hasNext();
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.featureType = null;
            this.types = null;
        }
    }
}

