/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.NoSuchElementException;
import org.geotools.data.AttributeReader;
import org.geotools.data.AttributeWriter;
import org.geotools.data.DataSourceException;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;

public class QueryData
implements AttributeReader,
AttributeWriter {
    protected Object[] fidAttributes;
    protected FeatureTypeInfo featureTypeInfo;
    protected ResultSet resultSet;
    protected Connection connection;
    protected Transaction transaction;
    protected Statement statement;
    protected FIDMapper mapper;
    protected AttributeIO[] attributeHandlers;
    protected int baseIndex;
    boolean hasNextCalled = false;
    boolean lastNext;

    public QueryData(FeatureTypeInfo featureTypeInfo, JDBCDataStore parentDataStore, Connection connection, Statement statement, ResultSet resultSet, Transaction transaction) throws IOException {
        this.featureTypeInfo = featureTypeInfo;
        this.mapper = featureTypeInfo.getFIDMapper();
        this.baseIndex = this.mapper.getColumnCount() + 1;
        this.resultSet = resultSet;
        this.statement = statement;
        this.connection = connection;
        this.transaction = transaction;
        this.fidAttributes = new Object[this.mapper.getColumnCount()];
        AttributeType[] attributeTypes = featureTypeInfo.getSchema().getAttributeTypes();
        this.attributeHandlers = new AttributeIO[attributeTypes.length];
        for (int i = 0; i < this.attributeHandlers.length; ++i) {
            this.attributeHandlers[i] = attributeTypes[i].isGeometry() ? parentDataStore.getGeometryAttributeIO(attributeTypes[i], this) : parentDataStore.getAttributeIO(attributeTypes[i]);
        }
    }

    public int getAttributeCount() {
        return this.attributeHandlers.length;
    }

    public AttributeIO[] getAttributeHandlers() {
        return this.attributeHandlers;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public FIDMapper getMapper() {
        return this.mapper;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void close() {
        this.close(null);
    }

    public void close(SQLException sqlException) {
        JDBCUtils.close(this.resultSet);
        JDBCUtils.close(this.statement);
        JDBCUtils.close(this.connection, this.transaction, sqlException);
        this.resultSet = null;
        this.statement = null;
        this.connection = null;
        this.transaction = null;
    }

    public Object read(int index) throws IOException, ArrayIndexOutOfBoundsException {
        AttributeIO reader = this.attributeHandlers[index];
        return reader.read(this.resultSet, index + this.baseIndex);
    }

    public void write(int i, Object currAtt) throws IOException {
        AttributeIO attributeHandler = this.attributeHandlers[i];
        attributeHandler.write(this.resultSet, this.baseIndex + i, currAtt);
    }

    public Object readFidColumn(int index) throws IOException {
        try {
            return this.resultSet.getObject(index + 1);
        }
        catch (SQLException e) {
            throw new DataSourceException("Error reading fid column " + index, e);
        }
    }

    public void writeFidColumn(int index, Object value) throws IOException {
        try {
            if (value == null) {
                this.resultSet.updateNull(index + 1);
            } else {
                this.resultSet.updateObject(index + 1, value);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Error writing fid column " + index, e);
        }
    }

    public FeatureType getFeatureType() {
        return this.featureTypeInfo.getSchema();
    }

    public void startInsert() throws SQLException {
        this.resultSet.moveToInsertRow();
    }

    public void deleteCurrentRow() throws SQLException {
        this.resultSet.deleteRow();
    }

    public void updateRow() throws SQLException {
        this.resultSet.updateRow();
    }

    public void doInsert() throws SQLException {
        this.resultSet.insertRow();
    }

    public FeatureTypeInfo getFeatureTypeInfo() {
        return this.featureTypeInfo;
    }

    public boolean isClosed() {
        return this.resultSet == null;
    }

    public void next() throws IOException {
        if (!this.hasNextCalled && !this.hasNext() || !this.lastNext) {
            throw new NoSuchElementException("No feature to read, hasNext did return false");
        }
        this.hasNextCalled = false;
    }

    public boolean hasNext() throws IOException {
        try {
            if (!this.hasNextCalled) {
                this.hasNextCalled = true;
                this.lastNext = this.resultSet.next();
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Problem moving on to the next attribute", e);
        }
        return this.lastNext;
    }

    public AttributeType getAttributeType(int index) throws ArrayIndexOutOfBoundsException {
        return this.featureTypeInfo.getSchema().getAttributeType(index);
    }
}

