/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.spi.RegisterableService;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.Factory;
import org.geotools.resources.cts.Resources;

public class AbstractFactory
implements Factory,
RegisterableService {
    public static final int MINIMUM_PRIORITY = 1;
    public static final int NORMAL_PRIORITY = 50;
    public static final int MAXIMUM_PRIORITY = 100;
    public final int priority;
    protected final Map hints = new LinkedHashMap();
    private final Map unmodifiableHints = Collections.unmodifiableMap(this.hints);

    protected AbstractFactory() {
        this(50);
    }

    protected AbstractFactory(int priority) {
        this.priority = priority;
        if (priority < 1 || priority > 100) {
            throw new IllegalArgumentException(Resources.format(82, "priority", new Integer(priority)));
        }
    }

    public Map getImplementationHints() {
        return this.unmodifiableHints;
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        Iterator it = registry.getServiceProviders(category, false);
        while (it.hasNext()) {
            Object provider = it.next();
            if (!(provider instanceof AbstractFactory)) continue;
            AbstractFactory factory = (AbstractFactory)provider;
            if (this.priority > factory.priority) {
                registry.setOrdering(category, this, factory);
                continue;
            }
            if (this.priority >= factory.priority) continue;
            registry.setOrdering(category, factory, this);
        }
    }

    public void onDeregistration(ServiceRegistry registry, Class category) {
    }
}

