/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.Filter;

public class DefaultAttributeType
implements AttributeType {
    protected final String name;
    protected final Class type;
    protected final boolean nillable;
    protected final int min;
    protected final int max;
    protected Object defaultValue;
    private Filter filter;

    public int getMinOccurs() {
        return 1;
    }

    public int getMaxOccurs() {
        return this.max;
    }

    protected DefaultAttributeType(String name, Class type, boolean nillable, int min, int max, Object defaultValue, Filter f) {
        String string = this.name = name == null ? "" : name;
        Class clazz = type == null ? Object.class : type;
        this.type = clazz;
        this.nillable = nillable;
        this.min = min;
        this.max = max;
        this.defaultValue = defaultValue;
        this.filter = f;
        if (defaultValue != null && !type.isAssignableFrom(defaultValue.getClass())) {
            throw new IllegalArgumentException("Default value does not match type");
        }
    }

    protected DefaultAttributeType(String name, Class type, boolean nillable, int min, int max, Object defaultValue) {
        this(name, type, nillable, min, max, defaultValue, Filter.NONE);
    }

    protected DefaultAttributeType(String name, Class type, boolean nillable, Object defaultValue) {
        this(name, type, nillable, 1, 1, defaultValue, Filter.NONE);
    }

    protected DefaultAttributeType(AttributeType copy) {
        this.name = copy.getName();
        this.type = copy.getType();
        this.nillable = copy.isNillable();
        this.min = copy.getMinOccurs();
        this.max = copy.getMaxOccurs();
        this.defaultValue = copy.createDefaultValue();
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public Object duplicate(Object src) throws IllegalAttributeException {
        if (src == null) {
            return null;
        }
        if (src instanceof String || src instanceof Integer || src instanceof Double || src instanceof Float || src instanceof Byte || src instanceof Boolean || src instanceof Short || src instanceof Long || src instanceof Character || src instanceof Number) {
            return src;
        }
        if (src instanceof Date) {
            return new Date(((Date)src).getTime());
        }
        if (src instanceof Object[]) {
            Object[] array = (Object[])src;
            Object[] copy = new Object[array.length];
            for (int i = 0; i < array.length; ++i) {
                copy[i] = this.duplicate(array[i]);
            }
            return copy;
        }
        if (src instanceof Geometry) {
            Geometry geometry = (Geometry)src;
            return geometry.clone();
        }
        if (src instanceof Feature) {
            Feature feature = (Feature)src;
            return feature.getFeatureType().duplicate(feature);
        }
        Class<?> type = src.getClass();
        if (type.isArray() && type.getComponentType().isPrimitive()) {
            int length = Array.getLength(src);
            Object copy = Array.newInstance(type.getComponentType(), length);
            System.arraycopy(src, 0, copy, 0, length);
            return copy;
        }
        if (type.isArray()) {
            int length = Array.getLength(src);
            Object copy = Array.newInstance(type.getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(copy, i, this.duplicate(Array.get(src, i)));
            }
            return copy;
        }
        if (src instanceof List) {
            List list = (List)src;
            ArrayList<Object> copy = new ArrayList<Object>(list.size());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                copy.add(this.duplicate(i.next()));
            }
            return Collections.unmodifiableList(copy);
        }
        if (src instanceof Map) {
            Map map = (Map)src;
            HashMap copy = new HashMap(map.size());
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                copy.put(entry.getKey(), this.duplicate(entry.getValue()));
            }
            return Collections.unmodifiableMap(copy);
        }
        throw new IllegalAttributeException("Do not know how to deep copy " + type.getName());
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.type.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        AttributeType att = (AttributeType)other;
        if (this.name == null && att.getName() != null) {
            return false;
        }
        if (!this.name.equals(att.getName())) {
            return false;
        }
        return this.type.equals(att.getType());
    }

    public boolean isGeometry() {
        return Geometry.class.isAssignableFrom(this.type);
    }

    public String toString() {
        String details = "name=" + this.name;
        details = details + " , type=" + this.type;
        details = details + " , nillable=" + this.nillable + ", min=" + this.min + ", max=" + this.min;
        return "DefaultAttributeType [" + details + "]";
    }

    public Object parse(Object value) throws IllegalArgumentException {
        return value;
    }

    public void validate(Object attribute) throws IllegalArgumentException {
        if (attribute == null) {
            if (!this.isNillable()) {
                throw new IllegalArgumentException(this.getName() + " is not nillable");
            }
            return;
        }
        if (!this.type.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(attribute.getClass().getName() + " is not an acceptable class for " + this.getName() + " as it is not assignable from " + this.type);
        }
    }

    public Object createDefaultValue() {
        return this.defaultValue;
    }

    public Filter getRestriction() {
        return this.filter;
    }
}

