/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.rmi.server.UID;
import java.util.Collections;
import java.util.List;
import org.geotools.feature.AttributeType;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SimpleFeature;
import org.opengis.util.Cloneable;

public class DefaultFeature
implements SimpleFeature,
Cloneable {
    protected String featureId;
    private final DefaultFeatureType schema;
    private Object[] attributes;
    private Envelope bounds;
    private FeatureCollection parent;

    protected DefaultFeature(DefaultFeatureType schema, Object[] attributes, String featureID) throws IllegalAttributeException, NullPointerException {
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        this.schema = schema;
        this.featureId = featureID == null ? this.defaultID() : featureID;
        this.attributes = new Object[schema.getAttributeCount()];
        this.setAttributes(attributes);
    }

    protected DefaultFeature(DefaultFeatureType schema, Object[] attributes) throws IllegalAttributeException {
        this(schema, attributes, null);
    }

    String defaultID() {
        return "fid-" + new UID().toString();
    }

    public FeatureType getFeatureType() {
        return this.schema;
    }

    public String getID() {
        return this.featureId;
    }

    public Object[] getAttributes(Object[] array) {
        Object[] retArray = array == null ? new Object[this.attributes.length] : array;
        System.arraycopy(this.attributes, 0, retArray, 0, this.attributes.length);
        return retArray;
    }

    public Object getAttribute(String xPath) {
        int idx = this.schema.find(xPath);
        if (idx == -1) {
            return null;
        }
        return this.attributes[idx];
    }

    public Object getAttribute(int index) {
        return this.attributes[index];
    }

    public void setAttribute(int position, Object val) throws IllegalAttributeException {
        AttributeType type = this.schema.getAttributeType(position);
        try {
            if (val == null && !type.isNillable()) {
                val = type.createDefaultValue();
            }
            Object parsed = type.parse(val);
            type.validate(parsed);
            this.setAttributeValue(position, parsed);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalAttributeException(type, val, iae);
        }
    }

    protected void setAttributeValue(int position, Object val) {
        this.attributes[position] = val;
    }

    public void setAttributes(Object[] attributes) throws IllegalAttributeException {
        Object[] newAtts = attributes;
        if (attributes == null) {
            newAtts = new Object[this.attributes.length];
        }
        if (newAtts.length != this.attributes.length) {
            throw new IllegalAttributeException("Wrong number of attributes expected " + this.schema.getAttributeCount() + " got " + newAtts.length);
        }
        int ii = newAtts.length;
        for (int i = 0; i < ii; ++i) {
            this.setAttribute(i, newAtts[i]);
        }
    }

    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        int idx = this.schema.find(xPath);
        if (idx < 0) {
            throw new IllegalAttributeException("No attribute named " + xPath);
        }
        this.setAttribute(idx, attribute);
    }

    public Geometry getDefaultGeometry() {
        int idx = this.schema.defaultGeomIdx;
        if (idx == -1) {
            return null;
        }
        return (Geometry)this.attributes[idx];
    }

    public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        int idx = this.schema.defaultGeomIdx;
        if (idx < 0) {
            throw new IllegalAttributeException("Feature does not have geometry");
        }
        this.attributes[idx] = geometry;
        this.bounds = null;
    }

    public int getNumberOfAttributes() {
        return this.attributes.length;
    }

    public Envelope getBounds() {
        if (this.bounds == null) {
            this.bounds = new Envelope();
            int n = this.schema.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                Envelope e;
                Geometry g;
                if (!this.schema.getAttributeType(i).isGeometry() || (g = (Geometry)this.attributes[i]) == null || (e = g.getEnvelopeInternal()).isNull()) continue;
                this.bounds.expandToInclude(e);
            }
        }
        return new Envelope(this.bounds);
    }

    public Object clone() {
        try {
            DefaultFeature clone = (DefaultFeature)super.clone();
            for (int i = 0; i < this.attributes.length; ++i) {
                try {
                    clone.setAttribute(i, this.attributes[i]);
                    continue;
                }
                catch (IllegalAttributeException e1) {
                    throw new RuntimeException("The impossible has happened", e1);
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("The impossible has happened", e);
        }
    }

    public String toString() {
        String retString = "Feature[ id=" + this.getID() + " , ";
        FeatureType featType = this.getFeatureType();
        int n = this.attributes.length;
        for (int i = 0; i < n; ++i) {
            retString = retString + featType.getAttributeType(i).getName() + "=";
            retString = retString + this.attributes[i];
            if (i + 1 >= n) continue;
            retString = retString + " , ";
        }
        retString = retString + " ]";
        return retString;
    }

    public int hashCode() {
        return this.featureId.hashCode() * this.schema.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Feature)) {
            return false;
        }
        Feature feat = (Feature)obj;
        if (!((Object)feat.getFeatureType()).equals(this.schema)) {
            return false;
        }
        if (this.featureId == null && feat.getID() != null) {
            return false;
        }
        if (!this.featureId.equals(feat.getID())) {
            return false;
        }
        int ii = this.attributes.length;
        for (int i = 0; i < ii; ++i) {
            Object otherAtt = feat.getAttribute(i);
            if (this.attributes[i] == null) {
                if (otherAtt == null) continue;
                return false;
            }
            if (this.attributes[i].equals(otherAtt)) continue;
            if (this.attributes[i] instanceof Geometry && otherAtt instanceof Geometry) {
                if (((Geometry)this.attributes[i]).equals((Geometry)otherAtt)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public FeatureCollection getParent() {
        return this.parent;
    }

    public void setParent(FeatureCollection collection) {
        if (this.parent == null) {
            this.parent = collection;
        }
    }

    public Feature toComplex() {
        try {
            return new ComplexWrapper(this);
        }
        catch (IllegalAttributeException iae) {
            throw new RuntimeException("the impossible has happened: ", iae);
        }
    }

    static final class ComplexWrapper
    extends DefaultFeature {
        private ComplexWrapper(DefaultFeatureType fType, Object[] atts, String fid) throws IllegalAttributeException {
            super(fType, ComplexWrapper.wrapInList(atts, fType.getAttributeCount()), fid);
        }

        public ComplexWrapper(DefaultFeatureType fType, Object[] atts) throws IllegalAttributeException {
            this(fType, atts, null);
        }

        public ComplexWrapper(SimpleFeature feature) throws IllegalAttributeException {
            this((DefaultFeatureType)feature.getFeatureType(), feature.getAttributes(null), feature.getID());
        }

        public void setAttribute(int index, Object value) throws IllegalAttributeException {
            this.checkList(value);
            List valList = (List)value;
            int listSize = valList.size();
            if (listSize == 0) {
                super.setAttribute(index, (Object)ComplexWrapper.wrapInList(null));
            } else {
                AttributeType type = super.getFeatureType().getAttributeType(index);
                Object val = valList.get(0);
                try {
                    Object parsed = type.parse(val);
                    type.validate(parsed);
                    this.setAttributeValue(index, ComplexWrapper.wrapInList(parsed));
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalAttributeException(type, val, iae);
                }
            }
        }

        private void checkList(Object value) throws IllegalAttributeException {
            if (value instanceof List) {
                List valList = (List)value;
                int listSize = valList.size();
                if (listSize > 1) {
                    String errMsg = "The attribute: " + valList + " has more " + "attributes (" + listSize + ") than is allowed by an " + " attributeType in a Simple Feature (1)";
                    throw new IllegalAttributeException(errMsg);
                }
            } else {
                String errMsg = "All objects set in a ComplexFeature must be Lists, to account for multiplicity";
                throw new IllegalAttributeException(errMsg);
            }
        }

        public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
            int idx = super.getFeatureType().find(xPath);
            if (idx < 0) {
                throw new IllegalAttributeException("No attribute named " + xPath);
            }
            this.setAttribute(idx, attribute);
        }

        protected static List wrapInList(Object attribute) {
            return Collections.singletonList(attribute);
        }

        protected static Object[] wrapInList(Object[] attributes, int defaultSize) {
            Object[] retArray = attributes;
            retArray = attributes == null ? new Object[defaultSize] : attributes;
            for (int i = 0; i < attributes.length; ++i) {
                retArray[i] = ComplexWrapper.wrapInList(attributes[i]);
            }
            return retArray;
        }
    }
}

