/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.feature.Feature;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilterImpl;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.IllegalFilterException;

public class BetweenFilterImpl
extends CompareFilterImpl
implements BetweenFilter {
    protected Expression middleValue = null;

    protected BetweenFilterImpl() throws IllegalFilterException {
        super((short)19);
    }

    public void addMiddleValue(Expression middleValue) {
        this.middleValue = middleValue;
    }

    public Expression getMiddleValue() {
        return this.middleValue;
    }

    public boolean contains(Feature feature) {
        if (this.middleValue == null) {
            return false;
        }
        Object leftObj = this.leftValue.getValue(feature);
        Object rightObj = this.rightValue.getValue(feature);
        Object middleObj = this.middleValue.getValue(feature);
        if (leftObj instanceof Number && middleObj instanceof Number && rightObj instanceof Number) {
            double left = ((Number)leftObj).doubleValue();
            double right = ((Number)rightObj).doubleValue();
            double mid = ((Number)middleObj).doubleValue();
            return left <= mid && right >= mid;
        }
        if (leftObj.getClass() == middleObj.getClass() && rightObj.getClass() == middleObj.getClass() && leftObj instanceof Comparable) {
            return ((Comparable)leftObj).compareTo(middleObj) <= 0 && ((Comparable)middleObj).compareTo(rightObj) <= 0;
        }
        String mesg = "Supplied between values are either not compatible or not supported for comparison: " + leftObj + " <= " + middleObj + " <= " + rightObj;
        throw new IllegalArgumentException(mesg);
    }

    public String toString() {
        return "[ " + this.leftValue.toString() + " < " + this.middleValue.toString() + " < " + this.rightValue.toString() + " ]";
    }

    public boolean equals(Object oFilter) {
        if (oFilter.getClass() == this.getClass()) {
            BetweenFilterImpl bFilter = (BetweenFilterImpl)oFilter;
            return bFilter.getFilterType() == this.filterType && bFilter.getLeftValue().equals(this.leftValue) && bFilter.getMiddleValue().equals(this.middleValue) && bFilter.getRightValue().equals(this.rightValue);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.leftValue == null ? 0 : this.leftValue.hashCode());
        result = 37 * result + (this.middleValue == null ? 0 : this.middleValue.hashCode());
        result = 37 * result + (this.rightValue == null ? 0 : this.rightValue.hashCode());
        return result;
    }

    public void accept(FilterVisitor visitor) {
        visitor.visit(this);
    }
}

