/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.IllegalFilterException;

public class CompareFilterImpl
extends AbstractFilterImpl
implements CompareFilter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    protected Expression leftValue = null;
    protected Expression rightValue = null;

    protected CompareFilterImpl(short filterType) throws IllegalFilterException {
        if (!CompareFilterImpl.isCompareFilter(filterType)) {
            throw new IllegalFilterException("Attempted to create compare filter with non-compare type.");
        }
        this.filterType = filterType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addLeftValue(Expression leftValue) throws IllegalFilterException {
        if (CompareFilterImpl.isMathFilter(this.filterType)) {
            if (!DefaultExpression.isMathExpression(leftValue.getType()) && !this.permissiveConstruction) throw new IllegalFilterException("Attempted to add non-math expression to math filter.");
            this.leftValue = leftValue;
            return;
        } else {
            this.leftValue = leftValue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addRightValue(Expression rightValue) throws IllegalFilterException {
        if (CompareFilterImpl.isMathFilter(this.filterType)) {
            if (!DefaultExpression.isMathExpression(this.leftValue.getType()) && !this.permissiveConstruction) throw new IllegalFilterException("Attempted to add non-math expression to math filter.");
            this.rightValue = rightValue;
            return;
        } else {
            this.rightValue = rightValue;
        }
    }

    public Expression getLeftValue() {
        return this.leftValue;
    }

    public Expression getRightValue() {
        return this.rightValue;
    }

    public boolean contains(Feature feature) {
        LOGGER.entering("CompareFilter", "contains");
        if (this.leftValue == null | this.rightValue == null) {
            LOGGER.finer("one value has not been set");
            return false;
        }
        try {
            if (!(this.leftValue.getValue(feature) instanceof Number) || !(this.rightValue.getValue(feature) instanceof Number)) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("is equals thingy");
                    LOGGER.finest("left value class: " + this.leftValue.getValue(feature).getClass().toString());
                    LOGGER.finest("right value class: " + this.rightValue.getValue(feature).getClass().toString());
                }
                Object leftObj = this.leftValue.getValue(feature);
                Object rightObj = this.rightValue.getValue(feature);
                if (leftObj.getClass() != rightObj.getClass()) {
                    if (Number.class.isAssignableFrom(leftObj.getClass()) && rightObj.getClass() == String.class) {
                        try {
                            rightObj = new Double(Double.parseDouble((String)rightObj));
                            leftObj = new Double(((Number)leftObj).doubleValue());
                        }
                        catch (Exception e) {
                            leftObj = leftObj.toString();
                            rightObj = rightObj.toString();
                        }
                    } else if (leftObj.getClass() == String.class && Number.class.isAssignableFrom(rightObj.getClass())) {
                        try {
                            leftObj = new Double(Double.parseDouble((String)leftObj));
                            rightObj = new Double(((Number)rightObj).doubleValue());
                        }
                        catch (Exception e) {
                            leftObj = leftObj.toString();
                            rightObj = rightObj.toString();
                        }
                    } else {
                        leftObj = leftObj.toString();
                        rightObj = rightObj.toString();
                    }
                }
                if (this.filterType == 14) {
                    return leftObj.equals(rightObj);
                }
                if (this.filterType == 23) {
                    return !leftObj.equals(rightObj);
                }
                if (leftObj.getClass() == rightObj.getClass() && leftObj instanceof Comparable) {
                    Comparable leftComp = (Comparable)leftObj;
                    Comparable rightComp = (Comparable)rightObj;
                    int comparison = leftComp.compareTo(rightComp);
                    if (this.filterType == 15) {
                        return comparison < 0;
                    }
                    if (this.filterType == 16) {
                        return comparison > 0;
                    }
                    if (this.filterType == 17) {
                        return comparison <= 0;
                    }
                    if (this.filterType == 18) {
                        return comparison >= 0;
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
            double leftResult = ((Number)this.leftValue.getValue(feature)).doubleValue();
            double rightResult = ((Number)this.rightValue.getValue(feature)).doubleValue();
            if (this.filterType == 14) {
                return leftResult == rightResult;
            }
            if (this.filterType == 23) {
                return leftResult != rightResult;
            }
            if (this.filterType == 15) {
                return leftResult < rightResult;
            }
            if (this.filterType == 16) {
                return leftResult > rightResult;
            }
            if (this.filterType == 17) {
                return leftResult <= rightResult;
            }
            if (this.filterType == 18) {
                return leftResult >= rightResult;
            }
            throw new IllegalArgumentException();
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public String toString() {
        String operator = null;
        if (this.filterType == 14) {
            operator = " = ";
        }
        if (this.filterType == 15) {
            operator = " < ";
        }
        if (this.filterType == 16) {
            operator = " > ";
        }
        if (this.filterType == 17) {
            operator = " <= ";
        }
        if (this.filterType == 18) {
            operator = " >= ";
        }
        if (this.filterType == 23) {
            operator = " != ";
        }
        return "[ " + this.leftValue + operator + this.rightValue + " ]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompareFilter) {
            CompareFilter cFilter = (CompareFilter)obj;
            return this.filterType == cFilter.getFilterType() && (this.leftValue == cFilter.getLeftValue() || this.leftValue != null && this.leftValue.equals(cFilter.getLeftValue())) && (this.rightValue == cFilter.getRightValue() || this.rightValue != null && this.rightValue.equals(cFilter.getRightValue()));
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.filterType;
        result = 37 * result + (this.leftValue == null ? 0 : this.leftValue.hashCode());
        result = 37 * result + (this.rightValue == null ? 0 : this.rightValue.hashCode());
        return result;
    }

    public void accept(FilterVisitor visitor) {
        visitor.visit(this);
    }
}

