/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;

public class GeometryFilterImpl
extends AbstractFilterImpl
implements GeometryFilter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.filter");
    protected Expression leftGeometry = null;
    protected Expression rightGeometry = null;

    protected GeometryFilterImpl(short filterType) throws IllegalFilterException {
        if (!GeometryFilterImpl.isGeometryFilter(filterType)) {
            throw new IllegalFilterException("Attempted to create geometry filter with non-geometry type.");
        }
        this.filterType = filterType;
    }

    public void addLeftGeometry(Expression leftGeometry) throws IllegalFilterException {
        if (!DefaultExpression.isGeometryExpression(leftGeometry.getType()) && !this.permissiveConstruction) {
            throw new IllegalFilterException("Attempted to add (left) non-geometry expression to geometry filter.");
        }
        this.leftGeometry = leftGeometry;
    }

    public void addRightGeometry(Expression rightGeometry) throws IllegalFilterException {
        if (!DefaultExpression.isGeometryExpression(rightGeometry.getType()) && !this.permissiveConstruction) {
            throw new IllegalFilterException("Attempted to add (right) non-geometryexpression to geometry filter.");
        }
        this.rightGeometry = rightGeometry;
    }

    public Expression getLeftGeometry() {
        return this.leftGeometry;
    }

    public Expression getRightGeometry() {
        return this.rightGeometry;
    }

    public boolean contains(Feature feature) {
        Geometry right = null;
        right = this.rightGeometry != null ? (Geometry)this.rightGeometry.getValue(feature) : feature.getDefaultGeometry();
        Geometry left = null;
        if (this.leftGeometry != null) {
            Object obj = this.leftGeometry.getValue(feature);
            left = (Geometry)obj;
        } else {
            left = feature.getDefaultGeometry();
        }
        if (left == null) {
            return false;
        }
        Envelope envRight = right.getEnvelopeInternal();
        Envelope envLeft = left.getEnvelopeInternal();
        if (this.filterType == 5) {
            if (envRight.equals((Object)envLeft)) {
                return left.equals(right);
            }
            return false;
        }
        if (this.filterType == 6) {
            if (envRight.intersects(envLeft)) {
                return left.disjoint(right);
            }
            return true;
        }
        if (this.filterType == 7) {
            if (envRight.intersects(envLeft)) {
                return left.intersects(right);
            }
            return false;
        }
        if (this.filterType == 9) {
            if (envRight.intersects(envLeft)) {
                return left.crosses(right);
            }
            return false;
        }
        if (this.filterType == 10) {
            if (envRight.contains(envLeft)) {
                return left.within(right);
            }
            return false;
        }
        if (this.filterType == 11) {
            if (envLeft.contains(envRight)) {
                return left.contains(right);
            }
            return false;
        }
        if (this.filterType == 12) {
            if (envLeft.intersects(envRight)) {
                return left.overlaps(right);
            }
            return false;
        }
        if (this.filterType == 8) {
            return left.touches(right);
        }
        if (this.filterType == 4) {
            if (envRight.contains(envLeft) || envLeft.contains(envRight)) {
                return true;
            }
            if (envRight.intersects(envLeft)) {
                return left.intersects(right);
            }
            return false;
        }
        return true;
    }

    public String toString() {
        String operator = null;
        if (this.filterType == 5) {
            operator = " equals ";
        } else if (this.filterType == 6) {
            operator = " disjoint ";
        } else if (this.filterType == 7) {
            operator = " intersects ";
        } else if (this.filterType == 9) {
            operator = " crosses ";
        } else if (this.filterType == 10) {
            operator = " within ";
        } else if (this.filterType == 11) {
            operator = " contains ";
        } else if (this.filterType == 12) {
            operator = " overlaps ";
        } else if (this.filterType == 13) {
            operator = " beyond ";
        } else if (this.filterType == 4) {
            operator = " bbox ";
        }
        if (this.leftGeometry == null && this.rightGeometry == null) {
            return "[ null" + operator + "null" + " ]";
        }
        if (this.leftGeometry == null) {
            return "[ null" + operator + this.rightGeometry.toString() + " ]";
        }
        if (this.rightGeometry == null) {
            return "[ " + this.leftGeometry.toString() + operator + "null" + " ]";
        }
        return "[ " + this.leftGeometry.toString() + operator + this.rightGeometry.toString() + " ]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeometryFilterImpl) {
            GeometryFilterImpl geomFilter = (GeometryFilterImpl)obj;
            boolean isEqual = true;
            isEqual = geomFilter.getFilterType() == this.filterType;
            LOGGER.finest("filter type match:" + isEqual + "; in:" + geomFilter.getFilterType() + "; out:" + this.filterType);
            isEqual = geomFilter.leftGeometry != null ? isEqual && geomFilter.leftGeometry.equals(this.leftGeometry) : isEqual && this.leftGeometry == null;
            LOGGER.finest("left geom match:" + isEqual + "; in:" + geomFilter.leftGeometry + "; out:" + this.leftGeometry);
            isEqual = geomFilter.rightGeometry != null ? isEqual && geomFilter.rightGeometry.equals(this.rightGeometry) : isEqual && this.rightGeometry == null;
            LOGGER.finest("right geom match:" + isEqual + "; in:" + geomFilter.rightGeometry + "; out:" + this.rightGeometry);
            return isEqual;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.filterType;
        result = 37 * result + (this.leftGeometry == null ? 0 : this.leftGeometry.hashCode());
        result = 37 * result + (this.rightGeometry == null ? 0 : this.rightGeometry.hashCode());
        return result;
    }

    public void accept(FilterVisitor visitor) {
        visitor.visit(this);
    }
}

