/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.feature.Feature;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;

public class LikeFilterImpl
extends AbstractFilterImpl
implements LikeFilter {
    private Expression attribute = null;
    private String pattern = null;
    private String wildcardSingle = ".?";
    private String wildcardMulti = ".*";
    private String escape = "\\";
    private Pattern compPattern = null;
    private Matcher match = null;

    private Matcher getMatcher() {
        if (this.match == null) {
            String pattern1 = new String(this.pattern);
            String wildcardMulti1 = new String(this.wildcardMulti);
            String wildcardSingle1 = new String(this.wildcardSingle);
            String escape1 = new String(this.escape);
            char esc = escape1.charAt(0);
            LOGGER.finer("wildcard " + wildcardMulti1 + " single " + wildcardSingle1);
            LOGGER.finer("escape " + escape1 + " esc " + esc + " esc == \\ " + (esc == '\\'));
            String escapedWildcardMulti = this.fixSpecials(wildcardMulti1);
            String escapedWildcardSingle = this.fixSpecials(wildcardSingle1);
            StringBuffer tmp = new StringBuffer("");
            boolean escapedMode = false;
            for (int i = 0; i < pattern1.length(); ++i) {
                char chr = pattern1.charAt(i);
                LOGGER.finer("tmp = " + tmp + " looking at " + chr);
                if (pattern1.regionMatches(false, i, escape1, 0, escape1.length())) {
                    LOGGER.finer("escape ");
                    escapedMode = true;
                    chr = pattern1.charAt(i += escape1.length());
                }
                if (pattern1.regionMatches(false, i, wildcardMulti1, 0, wildcardMulti1.length())) {
                    LOGGER.finer("multi wildcard");
                    if (escapedMode) {
                        LOGGER.finer("escaped ");
                        tmp.append(escapedWildcardMulti);
                    } else {
                        tmp.append(".*");
                    }
                    i += wildcardMulti1.length() - 1;
                    escapedMode = false;
                    continue;
                }
                if (pattern1.regionMatches(false, i, wildcardSingle1, 0, wildcardSingle1.length())) {
                    LOGGER.finer("single wildcard");
                    if (escapedMode) {
                        LOGGER.finer("escaped ");
                        tmp.append(escapedWildcardSingle);
                    } else {
                        tmp.append(".?");
                    }
                    i += wildcardSingle1.length() - 1;
                    escapedMode = false;
                    continue;
                }
                if (this.isSpecial(chr)) {
                    LOGGER.finer("special");
                    tmp.append(this.escape + chr);
                    escapedMode = false;
                    continue;
                }
                tmp.append(chr);
                escapedMode = false;
            }
            pattern1 = tmp.toString();
            LOGGER.finer("final pattern " + pattern1);
            this.compPattern = Pattern.compile(pattern1);
            this.match = this.compPattern.matcher("");
        }
        return this.match;
    }

    protected LikeFilterImpl() {
        this.filterType = (short)20;
    }

    public void setValue(Expression attribute) throws IllegalFilterException {
        if (attribute.getType() == 111 && !this.permissiveConstruction) {
            throw new IllegalFilterException("Attempted to add something other than a string attribute expression to a like filter.");
        }
        this.attribute = attribute;
    }

    public Expression getValue() {
        return this.attribute;
    }

    public void setPattern(Expression p, String wildcardMulti, String wildcardSingle, String escape) {
        this.setPattern(p.toString(), wildcardMulti, wildcardSingle, escape);
    }

    public void setPattern(String pattern, String wildcardMulti, String wildcardSingle, String escape) {
        this.match = null;
        this.pattern = pattern;
        this.wildcardMulti = wildcardMulti;
        this.wildcardSingle = wildcardSingle;
        this.escape = escape;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean contains(Feature feature) {
        if (this.attribute == null) {
            return false;
        }
        Object value = this.attribute.getValue(feature);
        if (null == value) {
            return false;
        }
        Matcher matcher = this.getMatcher();
        matcher.reset(this.attribute.getValue(feature).toString());
        return matcher.matches();
    }

    public String toString() {
        return "[ " + this.attribute.toString() + " is like " + this.pattern + " ]";
    }

    public String getEscape() {
        return this.escape;
    }

    public String getWildcardMulti() {
        return this.wildcardMulti;
    }

    public String getWildcardSingle() {
        return this.wildcardSingle;
    }

    private boolean isSpecial(char chr) {
        return chr == '.' || chr == '?' || chr == '*' || chr == '^' || chr == '$' || chr == '+' || chr == '[' || chr == ']' || chr == '(' || chr == ')' || chr == '|' || chr == '\\' || chr == '&';
    }

    private String fixSpecials(String inString) {
        StringBuffer tmp = new StringBuffer("");
        for (int i = 0; i < inString.length(); ++i) {
            char chr = inString.charAt(i);
            if (this.isSpecial(chr)) {
                tmp.append(this.escape + chr);
                continue;
            }
            tmp.append(chr);
        }
        return tmp.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LikeFilterImpl) {
            LikeFilterImpl lFilter = (LikeFilterImpl)obj;
            return lFilter.getFilterType() == this.filterType && lFilter.getValue().equals(this.attribute) && lFilter.getPattern().equals(this.pattern);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = 37 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public void accept(FilterVisitor visitor) {
        visitor.visit(this);
    }
}

