/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.io.Serializable;
import org.geotools.geometry.GeneralDirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class DirectPosition1D
implements DirectPosition,
Serializable,
Cloneable {
    private static final long serialVersionUID = 3235094562875693710L;
    private CoordinateReferenceSystem crs;
    public double ordinate;

    public DirectPosition1D() {
    }

    public DirectPosition1D(CoordinateReferenceSystem crs) {
        this.setCoordinateReferenceSystem(crs);
    }

    public DirectPosition1D(double ordinate) {
        this.ordinate = ordinate;
    }

    public DirectPosition1D(DirectPosition point) {
        this.setLocation(point);
    }

    public DirectPosition getPosition() {
        return this;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        GeneralDirectPosition.checkCoordinateReferenceSystemDimension(crs, 1);
        this.crs = crs;
    }

    public final int getDimension() {
        return 1;
    }

    public double[] getCoordinates() {
        return new double[]{this.ordinate};
    }

    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        if (dimension == 0) {
            return this.ordinate;
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public final void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        if (dimension != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(dimension));
        }
        this.ordinate = value;
    }

    public void setLocation(DirectPosition position) throws MismatchedDimensionException {
        GeneralDirectPosition.ensureDimensionMatch("position", position.getDimension(), 1);
        this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
        this.ordinate = position.getOrdinate(0);
    }

    public String toString() {
        return GeneralDirectPosition.toString(this, this.getCoordinates());
    }

    public int hashCode() {
        long value = Double.doubleToLongBits(this.ordinate);
        int code = (int)value ^ (int)(value >>> 32);
        if (this.crs != null) {
            code ^= this.crs.hashCode();
        }
        return code;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }
}

