/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.NoSuchElementException;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.PreciseCoordinateSequenceTransformer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class JTS {
    public static Envelope empty() {
        Envelope envelope = new Envelope();
        envelope.setToNull();
        return envelope;
    }

    public static ReferencedEnvelope create(Envelope env, CoordinateReferenceSystem crs) {
        return new ReferencedEnvelope(env, crs);
    }

    public static Envelope transform(Envelope envelope, MathTransform transform, int npoints) throws TransformException {
        int t;
        double[] coordsEnvPoly = new double[4 * (npoints += 2) * 2];
        double[] newCoords = new double[4 * npoints * 2];
        int offset = 0;
        for (t = 0; t < npoints; ++t) {
            coordsEnvPoly[offset] = envelope.getMinX();
            coordsEnvPoly[offset + 1] = envelope.getMinY() + (envelope.getMaxY() - envelope.getMinY()) / (double)(npoints - 1) * (double)t;
            coordsEnvPoly[offset + 2] = envelope.getMaxX();
            coordsEnvPoly[offset + 3] = envelope.getMinY() + (envelope.getMaxY() - envelope.getMinY()) / (double)(npoints - 1) * (double)t;
            offset += 4;
        }
        for (t = 0; t < npoints; ++t) {
            coordsEnvPoly[offset] = envelope.getMinX() + (envelope.getMaxX() - envelope.getMinX()) / (double)(npoints - 1) * (double)t;
            coordsEnvPoly[offset + 1] = envelope.getMinY();
            coordsEnvPoly[offset + 2] = envelope.getMinX() + (envelope.getMaxX() - envelope.getMinX()) / (double)(npoints - 1) * (double)t;
            coordsEnvPoly[offset + 3] = envelope.getMaxY();
            offset += 4;
        }
        JTS.xform(transform, coordsEnvPoly, newCoords, 2);
        Envelope result = new Envelope();
        for (int t2 = 0; t2 < npoints * 4; ++t2) {
            result.expandToInclude(newCoords[t2 * 2], newCoords[t2 * 2 + 1]);
        }
        return result;
    }

    public static void xform(MathTransform mt, double[] src, double[] dest, int dimensions) throws TransformException {
        JTS.xform(mt, src, dest, dimensions, 0.1f);
    }

    public static void xform(MathTransform mt, double[] src, double[] dest, int dimensions, float failureThreshold) throws TransformException {
        int numCoords = dest.length / 2;
        int failures = 0;
        int threshold = (int)((float)numCoords * failureThreshold);
        boolean startPointTransformed = true;
        for (int i = 0; i < dest.length; i += dimensions) {
            try {
                mt.transform(src, i, dest, i, 1);
                if (startPointTransformed) continue;
                startPointTransformed = true;
                for (int j = 0; j < i; ++j) {
                    dest[j] = src[i - dimensions];
                }
                continue;
            }
            catch (TransformException e) {
                ++failures;
                if (i == 0) {
                    startPointTransformed = false;
                    continue;
                }
                if (!startPointTransformed) continue;
                for (int j = i - dimensions; j < dimensions; ++j) {
                    dest[j] = src[i - dimensions];
                }
            }
        }
        if (!startPointTransformed) {
            throw new TransformException("Unable to transform any of the points in the shape");
        }
    }

    public static Envelope transform(Envelope envelope, MathTransform transform) throws TransformException {
        double[] coords = new double[]{envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY()};
        double[] newcoords = new double[4];
        transform.transform(coords, 0, newcoords, 0, 2);
        return new Envelope(newcoords[0], newcoords[2], newcoords[1], newcoords[3]);
    }

    public static ReferencedEnvelope transform(ReferencedEnvelope envelope, CoordinateReferenceSystem crs, boolean lenient) throws TransformException, OperationNotFoundException, NoSuchElementException, FactoryException {
        double[] coords = new double[]{envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY()};
        double[] newcoords = new double[4];
        MathTransform transform = CRS.transform(envelope.getCRS(), crs, lenient);
        transform.transform(coords, 0, newcoords, 0, 2);
        return new ReferencedEnvelope(new Envelope(newcoords[0], newcoords[2], newcoords[1], newcoords[3]), crs);
    }

    public static GeometryCoordinateSequenceTransformer createGeometryTransformer() {
        return new GeometryCoordinateSequenceTransformer();
    }

    public static GeometryCoordinateSequenceTransformer createPreciseGeometryTransformer(double flatness) {
        PreciseCoordinateSequenceTransformer t = new PreciseCoordinateSequenceTransformer();
        t.setFlatness(flatness);
        return new GeometryCoordinateSequenceTransformer(t);
    }

    public static Geometry transform(Geometry geom, MathTransform transform) throws MismatchedDimensionException, TransformException {
        GeometryCoordinateSequenceTransformer transformer = JTS.createGeometryTransformer();
        transformer.setMathTransform(transform);
        return transformer.transform(geom);
    }

    public static Geometry preciseTransform(Geometry geom, double flatness, MathTransform transform) throws MismatchedDimensionException, TransformException {
        GeometryCoordinateSequenceTransformer transformer = JTS.createPreciseGeometryTransformer(flatness);
        transformer.setMathTransform(transform);
        return transformer.transform(geom);
    }

    public static Coordinate transform(Coordinate source, Coordinate dest, MathTransform transform) throws TransformException {
        if (dest == null) {
            dest = new Coordinate();
        }
        double[] array = null;
        if (transform.getSourceDimensions() == 2) {
            array = new double[]{source.x, source.y};
        } else if (transform.getSourceDimensions() == 3) {
            array = new double[]{source.x, source.y, source.z};
        }
        transform.transform(array, 0, array, 0, 1);
        dest.x = array[0];
        dest.y = array[1];
        if (transform.getTargetDimensions() == 3) {
            dest.z = array[2];
        }
        return dest;
    }

    public static Envelope toGeographic(Envelope env, CoordinateReferenceSystem crs) throws OperationNotFoundException, NoSuchElementException, FactoryException, TransformException {
        if (crs.equals(DefaultGeographicCRS.WGS84)) {
            return env;
        }
        MathTransform transform = FactoryFinder.getCoordinateOperationFactory(null).createOperation(crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84).getMathTransform();
        return JTS.transform(env, transform);
    }

    public static class ReferencedEnvelope
    extends Envelope {
        private CoordinateReferenceSystem crs = null;

        public ReferencedEnvelope(Envelope env, CoordinateReferenceSystem crs) {
            super(env);
            this.crs = crs;
        }

        public CoordinateReferenceSystem getCRS() {
            return this.crs;
        }
    }
}

