/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.geometry.jts.CoordinateSequenceTransformer;
import org.geotools.geometry.jts.DefaultCoordinateSequenceTransformer;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeometryCoordinateSequenceTransformer {
    private MathTransform transform;
    private CoordinateSequenceTransformer csTransformer;

    public GeometryCoordinateSequenceTransformer() {
        this.csTransformer = new DefaultCoordinateSequenceTransformer();
    }

    public GeometryCoordinateSequenceTransformer(CoordinateSequenceTransformer transformer) {
        this.csTransformer = transformer;
    }

    public void setMathTransform(MathTransform transform) {
        this.transform = transform;
    }

    public Geometry transform(Geometry g) throws TransformException {
        GeometryFactory factory = g.getFactory();
        if (g instanceof Point) {
            return this.transformPoint((Point)g, factory);
        }
        if (g instanceof MultiPoint) {
            MultiPoint mp = (MultiPoint)g;
            Point[] points = new Point[mp.getNumGeometries()];
            for (int i = 0; i < points.length; ++i) {
                points[i] = this.transformPoint((Point)mp.getGeometryN(i), factory);
            }
            return factory.createMultiPoint(points);
        }
        if (g instanceof LineString) {
            return this.transformLineString((LineString)g, factory);
        }
        if (g instanceof MultiLineString) {
            MultiLineString mls = (MultiLineString)g;
            LineString[] lines = new LineString[mls.getNumGeometries()];
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = this.transformLineString((LineString)mls.getGeometryN(i), factory);
            }
            return factory.createMultiLineString(lines);
        }
        if (g instanceof Polygon) {
            return this.transformPolygon((Polygon)g, factory);
        }
        if (g instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)g;
            Polygon[] polygons = new Polygon[mp.getNumGeometries()];
            for (int i = 0; i < polygons.length; ++i) {
                polygons[i] = this.transformPolygon((Polygon)mp.getGeometryN(i), factory);
            }
            return factory.createMultiPolygon(polygons);
        }
        if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            Geometry[] geoms = new Geometry[gc.getNumGeometries()];
            for (int i = 0; i < geoms.length; ++i) {
                geoms[i] = this.transform(gc.getGeometryN(i));
            }
            return factory.createGeometryCollection(geoms);
        }
        throw new IllegalArgumentException("Unsupported geometry type " + g.getClass());
    }

    public LineString transformLineString(LineString ls, GeometryFactory gf) throws TransformException {
        CoordinateSequence cs = this.projectCoordinateSequence(ls.getCoordinateSequence());
        if (ls instanceof LinearRing) {
            return gf.createLinearRing(cs);
        }
        return gf.createLineString(cs);
    }

    public Point transformPoint(Point point, GeometryFactory gf) throws TransformException {
        CoordinateSequence cs = this.projectCoordinateSequence(point.getCoordinateSequence());
        return gf.createPoint(cs);
    }

    public CoordinateSequence projectCoordinateSequence(CoordinateSequence cs) throws TransformException {
        return this.csTransformer.transform(cs, this.transform);
    }

    public Polygon transformPolygon(Polygon polygon, GeometryFactory gf) throws TransformException {
        LinearRing exterior = (LinearRing)this.transformLineString(polygon.getExteriorRing(), gf);
        LinearRing[] interiors = new LinearRing[polygon.getNumInteriorRing()];
        for (int i = 0; i < interiors.length; ++i) {
            interiors[i] = (LinearRing)this.transformLineString(polygon.getInteriorRingN(i), gf);
        }
        return gf.createPolygon(exterior, interiors);
    }
}

