/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.geotools.gml.SubHandler;
import org.geotools.gml.SubHandlerFactory;

public class SubHandlerMulti
extends SubHandler {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.gml");
    private static final Collection BASE_GEOMETRY_TYPES = new Vector<String>(Arrays.asList("Point", "LineString", "Polygon"));
    private GeometryFactory geometryFactory = new GeometryFactory();
    private SubHandlerFactory handlerFactory = new SubHandlerFactory();
    private SubHandler currentHandler;
    private List geometries = new Vector();
    private String internalType;
    private boolean internalTypeSet = false;

    public void subGeometry(String message, int type) {
        LOGGER.fine("subGeometry message = " + message + " type = " + type);
        if (!this.internalTypeSet && BASE_GEOMETRY_TYPES.contains(message)) {
            this.internalType = message;
            this.internalTypeSet = true;
            LOGGER.fine("Internal type set to " + message);
        }
        if (message.equals(this.internalType)) {
            if (type == 1) {
                this.currentHandler = this.handlerFactory.create(this.internalType);
            } else if (type == 2) {
                this.geometries.add(this.currentHandler.create(this.geometryFactory));
            } else if (type == 3) {
                this.currentHandler.subGeometry(message, type);
            }
        } else {
            this.currentHandler.subGeometry(message, type);
            LOGGER.fine(this.internalType + " != " + message);
        }
    }

    public void addCoordinate(Coordinate coordinate) {
        this.currentHandler.addCoordinate(coordinate);
    }

    public boolean isComplete(String message) {
        return message.equals("Multi" + this.internalType);
    }

    public Geometry create(GeometryFactory geometryFactory) {
        if (this.internalType.equals("Point")) {
            MultiPoint mp = geometryFactory.createMultiPoint(GeometryFactory.toPointArray((Collection)this.geometries));
            LOGGER.fine("created " + mp);
            return mp;
        }
        if (this.internalType.equals("LineString")) {
            MultiLineString ml = geometryFactory.createMultiLineString(GeometryFactory.toLineStringArray((Collection)this.geometries));
            LOGGER.fine("created " + ml);
            return ml;
        }
        if (this.internalType.equals("Polygon")) {
            MultiPolygon mp = geometryFactory.createMultiPolygon(GeometryFactory.toPolygonArray((Collection)this.geometries));
            LOGGER.fine("created " + mp);
            return mp;
        }
        return null;
    }
}

