/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import javax.imageio.IIOException;
import org.geotools.io.DefaultFileFilter;
import org.geotools.io.LineFormat;
import org.geotools.resources.gcs.Resources;
import org.geotools.resources.image.ColorUtilities;

public class PaletteFactory {
    private final PaletteFactory parent;
    private final ClassLoader loader;
    private final File directory;
    private final String extension;
    private final Charset charset;
    private final Locale locale;

    public PaletteFactory(PaletteFactory parent, ClassLoader loader, File directory, String extension, Charset charset, Locale locale) {
        if (extension != null && !extension.startsWith(".")) {
            extension = '.' + extension;
        }
        this.parent = parent;
        this.loader = loader;
        this.directory = directory;
        this.extension = extension;
        this.charset = charset;
        this.locale = locale;
    }

    public String[] getAvailableNames() {
        File dir;
        File file = dir = this.directory != null ? this.directory : new File(".");
        if (this.loader != null && (dir = PaletteFactory.toFile(this.loader.getResource(dir.getPath()))) == null) {
            return null;
        }
        if (!dir.isDirectory()) {
            return null;
        }
        String[] names = dir.list(new DefaultFileFilter('*' + this.extension));
        int extLg = this.extension.length();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            int lg = name.length();
            if (lg <= extLg || !name.regionMatches(true, lg - extLg, this.extension, 0, extLg)) continue;
            names[i] = name.substring(0, lg - extLg);
        }
        return names;
    }

    private static File toFile(URL url) {
        if (url != null && url.getProtocol().equalsIgnoreCase("file")) {
            return new File(url.getPath());
        }
        return null;
    }

    private BufferedReader getReader(String name) throws IOException {
        InputStream stream;
        if (this.extension != null && !name.endsWith(this.extension)) {
            name = name + this.extension;
        }
        File file = new File(this.directory, name);
        if (this.loader != null) {
            stream = this.loader.getResourceAsStream(file.getPath());
        } else {
            FileInputStream fileInputStream = stream = file.exists() ? new FileInputStream(file) : null;
        }
        if (stream == null) {
            return null;
        }
        return this.getReader(stream);
    }

    private BufferedReader getReader(InputStream stream) throws IOException {
        InputStreamReader reader = this.charset != null ? new InputStreamReader(stream, this.charset) : new InputStreamReader(stream);
        return new BufferedReader(reader);
    }

    private Color[] getColors(BufferedReader input) throws IOException {
        String line;
        int[] values = new int[3];
        LineFormat reader = this.locale != null ? new LineFormat(this.locale) : new LineFormat();
        ArrayList<Color> colors = new ArrayList<Color>();
        while ((line = input.readLine()) != null) {
            try {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || reader.setLine(line) == 0) continue;
                values = reader.getValues(values);
                colors.add(new Color(PaletteFactory.byteValue(values[0]), PaletteFactory.byteValue(values[1]), PaletteFactory.byteValue(values[2])));
            }
            catch (ParseException exception) {
                IIOException error = new IIOException(exception.getLocalizedMessage());
                error.initCause(exception);
                throw error;
            }
        }
        return colors.toArray(new Color[colors.size()]);
    }

    public Color[] getColors(String name) throws IOException {
        BufferedReader reader = this.getReader(name);
        if (reader == null) {
            return this.parent != null ? this.parent.getColors(name) : null;
        }
        Color[] colors = this.getColors(reader);
        reader.close();
        return colors;
    }

    public Color[] getColors(URL url) throws IOException {
        BufferedReader reader = this.getReader(url.openStream());
        Color[] colors = this.getColors(reader);
        reader.close();
        return colors;
    }

    public IndexColorModel getIndexColorModel(String name) throws IOException {
        return this.getIndexColorModel(name, 0, 256);
    }

    private IndexColorModel getIndexColorModel(String name, int lower, int upper) throws IOException {
        Color[] colors = this.getColors(name);
        if (colors == null) {
            return this.parent != null ? this.parent.getIndexColorModel(name, lower, upper) : null;
        }
        int[] ARGB = new int[1 << ColorUtilities.getBitCount(upper)];
        ColorUtilities.expand(colors, ARGB, lower, upper);
        return ColorUtilities.getIndexColorModel(ARGB);
    }

    private static int byteValue(int value) throws ParseException {
        if (value >= 0 && value < 256) {
            return value;
        }
        throw new ParseException(Resources.format(70, new Integer(value)), 0);
    }
}

