/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.io;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Locale;
import org.geotools.resources.ClassChanger;
import org.geotools.resources.XArray;
import org.geotools.resources.rsc.Resources;

public class LineFormat {
    private int count;
    private Object[] data;
    private final Format[] format;
    private final ParsePosition position = new ParsePosition(0);
    private int[] limits;
    private String line;

    public LineFormat() {
        this(NumberFormat.getNumberInstance());
    }

    public LineFormat(Locale locale) {
        this(NumberFormat.getNumberInstance(locale));
    }

    public LineFormat(Format format) throws NullPointerException {
        this.data = new Object[16];
        this.limits = new int[17];
        this.format = new Format[]{format};
        if (format == null) {
            Integer one = new Integer(1);
            throw new NullPointerException(Resources.format(15, one, one));
        }
    }

    public LineFormat(Format[] formats) throws NullPointerException {
        this.data = new Object[formats.length];
        this.format = new Format[formats.length];
        this.limits = new int[formats.length + 1];
        System.arraycopy(formats, 0, this.format, 0, formats.length);
        for (int i = 0; i < this.format.length; ++i) {
            if (this.format[i] != null) continue;
            throw new NullPointerException(Resources.format(15, new Integer(i + 1), new Integer(this.format.length)));
        }
    }

    public synchronized void clear() {
        this.line = null;
        Arrays.fill(this.data, null);
        this.count = 0;
    }

    public int setLine(String line) throws ParseException {
        return this.setLine(line, 0, line.length());
    }

    public synchronized int setLine(String line, int lower, int upper) throws ParseException {
        this.line = line;
        Arrays.fill(this.data, null);
        this.count = 0;
        while (lower < upper) {
            if (Character.isWhitespace(line.charAt(lower))) {
                ++lower;
                continue;
            }
            this.position.setIndex(lower);
            Object datum = this.format[Math.min(this.count, this.format.length - 1)].parseObject(line, this.position);
            int next = this.position.getIndex();
            if (datum == null || next <= lower) {
                int error;
                int end;
                for (end = error = this.position.getErrorIndex(); end < upper && !Character.isWhitespace(line.charAt(end)); ++end) {
                }
                throw new ParseException(Resources.format(17, line.substring(lower, end).trim(), line.substring(error, Math.min(error + 1, end))), error);
            }
            if (this.count >= this.data.length) {
                this.data = XArray.resize(this.data, this.count + Math.min(this.count, 256));
                this.limits = XArray.resize(this.limits, this.data.length + 1);
            }
            this.limits[this.count] = lower;
            this.data[this.count++] = datum;
            lower = next;
        }
        this.limits[this.count] = lower;
        return this.count;
    }

    public synchronized int getValueCount() {
        return this.count;
    }

    public synchronized void setValue(int index, Object value) throws ArrayIndexOutOfBoundsException {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (index == this.count) {
            if (index == this.data.length) {
                this.data = XArray.resize(this.data, index + Math.min(index, 256));
            }
            ++this.count;
        }
        this.data[index] = value;
    }

    public synchronized Object getValue(int index) throws ArrayIndexOutOfBoundsException {
        if (index < this.count) {
            return this.data[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    private Number getNumber(int index) throws ParseException {
        ClassNotFoundException error = null;
        if (this.data[index] instanceof Comparable) {
            try {
                return ClassChanger.toNumber((Comparable)this.data[index]);
            }
            catch (ClassNotFoundException exception) {
                error = exception;
            }
        }
        ParseException exception = new ParseException(Resources.format(19, this.data[index]), this.limits[index]);
        if (error != null) {
            exception.initCause(error);
        }
        throw exception;
    }

    public synchronized double[] getValues(double[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new double[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            array[i] = this.getNumber(i).doubleValue();
        }
        return array;
    }

    public synchronized float[] getValues(float[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new float[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            array[i] = this.getNumber(i).floatValue();
        }
        return array;
    }

    public synchronized long[] getValues(long[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new long[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number n = this.getNumber(i);
            array[i] = n.longValue();
            if ((double)array[i] == n.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return array;
    }

    public synchronized int[] getValues(int[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new int[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number n = this.getNumber(i);
            array[i] = n.intValue();
            if ((double)array[i] == n.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return array;
    }

    public synchronized short[] getValues(short[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new short[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number n = this.getNumber(i);
            array[i] = n.shortValue();
            if ((double)array[i] == n.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return array;
    }

    public synchronized byte[] getValues(byte[] array) throws ParseException {
        if (array != null) {
            this.checkLength(array.length);
        } else {
            array = new byte[this.count];
        }
        for (int i = 0; i < this.count; ++i) {
            Number n = this.getNumber(i);
            array[i] = n.byteValue();
            if ((double)array[i] == n.doubleValue()) continue;
            throw this.notAnInteger(i);
        }
        return array;
    }

    private void checkLength(int expected) throws ParseException {
        if (this.count != expected) {
            int lower = this.limits[Math.min(this.count, expected)];
            int upper = this.limits[Math.min(this.count, expected + 1)];
            throw new ParseException(Resources.format(this.count < expected ? 5 : 4, new Integer(this.count), new Integer(expected), this.line.substring(lower, upper).trim()), lower);
        }
    }

    private ParseException notAnInteger(int i) {
        return new ParseException(Resources.format(10, this.line.substring(this.limits[i], this.limits[i + 1])), this.limits[i]);
    }

    public String toString() {
        FieldPosition field = new FieldPosition(0);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.count; ++i) {
            if (i != 0) {
                buffer.append('\t');
            }
            buffer = this.format[Math.min(this.format.length - 1, i)].format(this.data[i], buffer, field);
        }
        return buffer.toString();
    }
}

