/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.util.Date;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;

public class CitationDateImpl
extends MetadataEntity
implements CitationDate {
    private static final long serialVersionUID = -2884791484254008454L;
    private long date = Long.MIN_VALUE;
    private DateType dateType;

    public CitationDateImpl() {
    }

    public CitationDateImpl(Date date, DateType dateType) {
        this.setDate(date);
        this.setDateType(dateType);
    }

    public synchronized Date getDate() {
        return this.date != Long.MIN_VALUE ? new Date(this.date) : null;
    }

    public synchronized void setDate(Date newValue) {
        this.checkWritePermission();
        this.date = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    public DateType getDateType() {
        return this.dateType;
    }

    public synchronized void setDateType(DateType newValue) {
        this.checkWritePermission();
        this.dateType = newValue;
    }

    protected void freeze() {
        super.freeze();
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            CitationDateImpl that = (CitationDateImpl)object;
            return this.date == that.date && Utilities.equals(this.dateType, that.dateType);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = -369636486;
        code ^= (int)this.date ^ (int)(this.date >>> 32);
        if (this.dateType != null) {
            code ^= this.dateType.hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.getDate());
    }
}

