/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.constraint;

import org.geotools.metadata.iso.constraint.ConstraintsImpl;
import org.geotools.resources.Utilities;
import org.opengis.metadata.constraint.Classification;
import org.opengis.metadata.constraint.SecurityConstraints;
import org.opengis.util.InternationalString;

public class SecurityConstraintsImpl
extends ConstraintsImpl
implements SecurityConstraints {
    private static final long serialVersionUID = 6412833018607679734L;
    private Classification classification;
    private InternationalString userNote;
    private InternationalString classificationSystem;
    private InternationalString handlingDescription;

    public SecurityConstraintsImpl() {
    }

    public SecurityConstraintsImpl(Classification classification) {
        this.setClassification(classification);
    }

    public Classification getClassification() {
        return this.classification;
    }

    public synchronized void setClassification(Classification newValue) {
        this.checkWritePermission();
        this.classification = newValue;
    }

    public InternationalString getUserNote() {
        return this.userNote;
    }

    public synchronized void setUserNote(InternationalString newValue) {
        this.checkWritePermission();
        this.userNote = newValue;
    }

    public InternationalString getClassificationSystem() {
        return this.classificationSystem;
    }

    public synchronized void setClassificatonSystem(InternationalString newValue) {
        this.checkWritePermission();
        this.classificationSystem = newValue;
    }

    public InternationalString getHandlingDescription() {
        return this.handlingDescription;
    }

    public synchronized void setHandlingDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.handlingDescription = newValue;
    }

    protected void freeze() {
        super.freeze();
        this.userNote = (InternationalString)SecurityConstraintsImpl.unmodifiable(this.userNote);
        this.classificationSystem = (InternationalString)SecurityConstraintsImpl.unmodifiable(this.classificationSystem);
        this.handlingDescription = (InternationalString)SecurityConstraintsImpl.unmodifiable(this.handlingDescription);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            SecurityConstraintsImpl that = (SecurityConstraintsImpl)object;
            return Utilities.equals(this.classification, that.classification) && Utilities.equals(this.userNote, that.userNote) && Utilities.equals(this.classificationSystem, that.classificationSystem) && Utilities.equals(this.handlingDescription, that.handlingDescription);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 1577171190;
        if (this.classification != null) {
            code ^= this.classification.hashCode();
        }
        if (this.userNote != null) {
            code ^= this.userNote.hashCode();
        }
        if (this.classificationSystem != null) {
            code ^= this.classificationSystem.hashCode();
        }
        if (this.handlingDescription != null) {
            code ^= this.handlingDescription.hashCode();
        }
        return code;
    }

    public synchronized String toString() {
        String useLimitation;
        StringBuffer buffer = new StringBuffer();
        if (this.classification != null) {
            buffer.append(this.classification.name().replace('_', ' '));
        }
        if ((useLimitation = super.toString()) != null && useLimitation.length() != 0) {
            SecurityConstraintsImpl.appendLineSeparator(buffer);
            buffer.append(useLimitation);
        }
        return buffer.toString();
    }
}

