/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.distribution;

import java.util.Collection;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.distribution.DigitalTransferOptions;
import org.opengis.metadata.distribution.Distributor;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.distribution.StandardOrderProcess;

public class DistributorImpl
extends MetadataEntity
implements Distributor {
    private static final long serialVersionUID = 7142984376823483766L;
    private ResponsibleParty distributorContact;
    private Collection distributionOrderProcesses;
    private Collection distributorFormats;
    private Collection distributorTransferOptions;

    public DistributorImpl() {
    }

    public DistributorImpl(ResponsibleParty distributorContact) {
        this.setDistributorContact(distributorContact);
    }

    public ResponsibleParty getDistributorContact() {
        return this.distributorContact;
    }

    public synchronized void setDistributorContact(ResponsibleParty newValue) {
        this.checkWritePermission();
        this.distributorContact = newValue;
    }

    public synchronized Collection getDistributionOrderProcesses() {
        this.distributionOrderProcesses = this.nonNullCollection(this.distributionOrderProcesses, StandardOrderProcess.class);
        return this.distributionOrderProcesses;
    }

    public synchronized void setDistributionOrderProcesses(Collection newValues) {
        this.distributionOrderProcesses = this.copyCollection(newValues, this.distributionOrderProcesses, StandardOrderProcess.class);
    }

    public synchronized Collection getDistributorFormats() {
        this.distributorFormats = this.nonNullCollection(this.distributorFormats, Format.class);
        return this.distributorFormats;
    }

    public synchronized void setDistributorFormats(Collection newValues) {
        this.distributorFormats = this.copyCollection(newValues, this.distributorFormats, Format.class);
    }

    public synchronized Collection getDistributorTransferOptions() {
        this.distributorTransferOptions = this.nonNullCollection(this.distributorTransferOptions, DigitalTransferOptions.class);
        return this.distributorTransferOptions;
    }

    public synchronized void setDistributorTransferOptions(Collection newValues) {
        this.distributorTransferOptions = this.copyCollection(newValues, this.distributorTransferOptions, DigitalTransferOptions.class);
    }

    protected void freeze() {
        super.freeze();
        this.distributorContact = (ResponsibleParty)DistributorImpl.unmodifiable(this.distributorContact);
        this.distributionOrderProcesses = (Collection)DistributorImpl.unmodifiable(this.distributionOrderProcesses);
        this.distributorFormats = (Collection)DistributorImpl.unmodifiable(this.distributorFormats);
        this.distributorTransferOptions = (Collection)DistributorImpl.unmodifiable(this.distributorTransferOptions);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            DistributorImpl that = (DistributorImpl)object;
            return Utilities.equals(this.distributorContact, that.distributorContact) && Utilities.equals(this.distributionOrderProcesses, that.distributionOrderProcesses) && Utilities.equals(this.distributorFormats, that.distributorFormats) && Utilities.equals(this.distributorTransferOptions, that.distributorTransferOptions);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 280661366;
        if (this.distributorContact != null) {
            code ^= this.distributorContact.hashCode();
        }
        if (this.distributionOrderProcesses != null) {
            code ^= ((Object)this.distributionOrderProcesses).hashCode();
        }
        if (this.distributorFormats != null) {
            code ^= ((Object)this.distributorFormats).hashCode();
        }
        if (this.distributorTransferOptions != null) {
            code ^= ((Object)this.distributorTransferOptions).hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.distributorContact);
    }
}

