/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.identification;

import java.util.Collection;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Keywords;
import org.opengis.metadata.identification.Progress;
import org.opengis.metadata.identification.Usage;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.util.InternationalString;

public class IdentificationImpl
extends MetadataEntity
implements Identification {
    private static final long serialVersionUID = -3715084806249419137L;
    private Citation citation;
    private InternationalString abstracts;
    private InternationalString purpose;
    private Collection credits;
    private Collection status;
    private Collection pointOfContacts;
    private Collection resourceMaintenance;
    private Collection graphicOverviews;
    private Collection resourceFormat;
    private Collection descriptiveKeywords;
    private Collection resourceSpecificUsages;
    private Collection resourceConstraints;

    public IdentificationImpl() {
    }

    public IdentificationImpl(Citation citation, InternationalString abstracts) {
        this.setCitation(citation);
        this.setAbstract(abstracts);
    }

    public Citation getCitation() {
        return this.citation;
    }

    public synchronized void setCitation(Citation newValue) {
        this.checkWritePermission();
        this.citation = newValue;
    }

    public InternationalString getAbstract() {
        return this.abstracts;
    }

    public synchronized void setAbstract(InternationalString newValue) {
        this.checkWritePermission();
        this.abstracts = newValue;
    }

    public InternationalString getPurpose() {
        return this.purpose;
    }

    public synchronized void setPurpose(InternationalString newValue) {
        this.checkWritePermission();
        this.purpose = newValue;
    }

    public synchronized Collection getCredits() {
        this.credits = this.nonNullCollection(this.credits, String.class);
        return this.credits;
    }

    public synchronized void setCredits(Collection newValues) {
        this.credits = this.copyCollection(newValues, this.credits, String.class);
    }

    public synchronized Collection getStatus() {
        this.status = this.nonNullCollection(this.status, Progress.class);
        return this.status;
    }

    public synchronized void setStatus(Collection newValues) {
        this.status = this.copyCollection(newValues, this.status, Progress.class);
    }

    public synchronized Collection getPointOfContacts() {
        this.pointOfContacts = this.nonNullCollection(this.pointOfContacts, ResponsibleParty.class);
        return this.pointOfContacts;
    }

    public synchronized void setPointOfContacts(Collection newValues) {
        this.pointOfContacts = this.copyCollection(newValues, this.pointOfContacts, ResponsibleParty.class);
    }

    public synchronized Collection getResourceMaintenance() {
        this.resourceMaintenance = this.nonNullCollection(this.resourceMaintenance, MaintenanceInformation.class);
        return this.resourceMaintenance;
    }

    public synchronized void setResourceMaintenance(Collection newValues) {
        this.resourceMaintenance = this.copyCollection(newValues, this.resourceMaintenance, MaintenanceInformation.class);
    }

    public synchronized Collection getGraphicOverviews() {
        this.graphicOverviews = this.nonNullCollection(this.graphicOverviews, BrowseGraphic.class);
        return this.graphicOverviews;
    }

    public synchronized void setGraphicOverviews(Collection newValues) {
        this.graphicOverviews = this.copyCollection(newValues, this.graphicOverviews, BrowseGraphic.class);
    }

    public synchronized Collection getResourceFormat() {
        this.resourceFormat = this.nonNullCollection(this.resourceFormat, Format.class);
        return this.resourceFormat;
    }

    public synchronized void setResourceFormat(Collection newValues) {
        this.resourceFormat = this.copyCollection(newValues, this.resourceFormat, Format.class);
    }

    public synchronized Collection getDescriptiveKeywords() {
        this.descriptiveKeywords = this.nonNullCollection(this.descriptiveKeywords, Keywords.class);
        return this.descriptiveKeywords;
    }

    public synchronized void setDescriptiveKeywords(Collection newValues) {
        this.descriptiveKeywords = this.copyCollection(newValues, this.descriptiveKeywords, Keywords.class);
    }

    public synchronized Collection getResourceSpecificUsages() {
        this.resourceSpecificUsages = this.nonNullCollection(this.resourceSpecificUsages, Usage.class);
        return this.resourceSpecificUsages;
    }

    public synchronized void setResourceSpecificUsages(Collection newValues) {
        this.resourceSpecificUsages = this.copyCollection(newValues, this.resourceSpecificUsages, Usage.class);
    }

    public synchronized Collection getResourceConstraints() {
        this.resourceConstraints = this.nonNullCollection(this.resourceConstraints, Constraints.class);
        return this.resourceConstraints;
    }

    public synchronized void setResourceConstraints(Collection newValues) {
        this.resourceConstraints = this.copyCollection(newValues, this.resourceConstraints, Constraints.class);
    }

    protected void freeze() {
        super.freeze();
        this.citation = (Citation)IdentificationImpl.unmodifiable(this.citation);
        this.abstracts = (InternationalString)IdentificationImpl.unmodifiable(this.abstracts);
        this.purpose = (InternationalString)IdentificationImpl.unmodifiable(this.purpose);
        this.credits = (Collection)IdentificationImpl.unmodifiable(this.credits);
        this.status = (Collection)IdentificationImpl.unmodifiable(this.status);
        this.pointOfContacts = (Collection)IdentificationImpl.unmodifiable(this.pointOfContacts);
        this.resourceMaintenance = (Collection)IdentificationImpl.unmodifiable(this.resourceMaintenance);
        this.resourceFormat = (Collection)IdentificationImpl.unmodifiable(this.resourceFormat);
        this.descriptiveKeywords = (Collection)IdentificationImpl.unmodifiable(this.descriptiveKeywords);
        this.resourceSpecificUsages = (Collection)IdentificationImpl.unmodifiable(this.resourceSpecificUsages);
        this.resourceConstraints = (Collection)IdentificationImpl.unmodifiable(this.resourceConstraints);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            IdentificationImpl that = (IdentificationImpl)object;
            return Utilities.equals(this.citation, that.citation) && Utilities.equals(this.abstracts, that.abstracts) && Utilities.equals(this.purpose, that.purpose) && Utilities.equals(this.credits, that.credits) && Utilities.equals(this.status, that.status) && Utilities.equals(this.pointOfContacts, that.pointOfContacts) && Utilities.equals(this.resourceMaintenance, that.resourceMaintenance) && Utilities.equals(this.resourceFormat, that.resourceFormat) && Utilities.equals(this.descriptiveKeywords, that.descriptiveKeywords) && Utilities.equals(this.resourceSpecificUsages, that.resourceSpecificUsages) && Utilities.equals(this.resourceConstraints, that.resourceConstraints);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 1426943615;
        if (this.citation != null) {
            code ^= this.citation.hashCode();
        }
        if (this.abstracts != null) {
            code ^= this.abstracts.hashCode();
        }
        if (this.purpose != null) {
            code ^= this.purpose.hashCode();
        }
        if (this.credits != null) {
            code ^= ((Object)this.credits).hashCode();
        }
        if (this.status != null) {
            code ^= ((Object)this.status).hashCode();
        }
        if (this.pointOfContacts != null) {
            code ^= ((Object)this.pointOfContacts).hashCode();
        }
        if (this.resourceMaintenance != null) {
            code ^= ((Object)this.resourceMaintenance).hashCode();
        }
        if (this.resourceFormat != null) {
            code ^= ((Object)this.resourceFormat).hashCode();
        }
        if (this.descriptiveKeywords != null) {
            code ^= ((Object)this.descriptiveKeywords).hashCode();
        }
        if (this.resourceSpecificUsages != null) {
            code ^= ((Object)this.resourceSpecificUsages).hashCode();
        }
        if (this.resourceConstraints != null) {
            code ^= ((Object)this.resourceConstraints).hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.resourceMaintenance);
    }
}

