/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.identification;

import java.util.Collection;
import java.util.Date;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.identification.Usage;
import org.opengis.util.InternationalString;

public class UsageImpl
extends MetadataEntity
implements Usage {
    private static final long serialVersionUID = 4059324536168287490L;
    private InternationalString specificUsage;
    private long usageDate = Long.MIN_VALUE;
    private InternationalString userDeterminedLimitations;
    private Collection userContactInfo;

    public UsageImpl() {
    }

    public UsageImpl(InternationalString specificUsage, Collection userContactInfo) {
        this.setUserContactInfo(userContactInfo);
        this.setSpecificUsage(specificUsage);
    }

    public InternationalString getSpecificUsage() {
        return this.specificUsage;
    }

    public synchronized void setSpecificUsage(InternationalString newValue) {
        this.checkWritePermission();
        this.specificUsage = newValue;
    }

    public synchronized Date getUsageDate() {
        return this.usageDate != Long.MIN_VALUE ? new Date(this.usageDate) : null;
    }

    public synchronized void setUsageDate(Date newValue) {
        this.checkWritePermission();
        this.usageDate = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    public InternationalString getUserDeterminedLimitations() {
        return this.userDeterminedLimitations;
    }

    public synchronized void setUserDeterminedLimitations(InternationalString newValue) {
        this.checkWritePermission();
        this.userDeterminedLimitations = newValue;
    }

    public synchronized Collection getUserContactInfo() {
        this.userContactInfo = this.nonNullCollection(this.userContactInfo, ResponsibleParty.class);
        return this.userContactInfo;
    }

    public synchronized void setUserContactInfo(Collection newValues) {
        this.userContactInfo = this.copyCollection(newValues, this.userContactInfo, ResponsibleParty.class);
    }

    protected void freeze() {
        super.freeze();
        this.specificUsage = (InternationalString)UsageImpl.unmodifiable(this.specificUsage);
        this.userDeterminedLimitations = (InternationalString)UsageImpl.unmodifiable(this.userDeterminedLimitations);
        this.userContactInfo = (Collection)UsageImpl.unmodifiable(this.userContactInfo);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            UsageImpl that = (UsageImpl)object;
            return this.usageDate == that.usageDate && Utilities.equals(this.specificUsage, that.specificUsage) && Utilities.equals(this.userDeterminedLimitations, that.userDeterminedLimitations) && Utilities.equals(this.userContactInfo, that.userContactInfo);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = -1906930430;
        if (this.specificUsage != null) {
            code ^= this.specificUsage.hashCode();
        }
        if (this.userDeterminedLimitations != null) {
            code ^= this.userDeterminedLimitations.hashCode();
        }
        if (this.userContactInfo != null) {
            code ^= ((Object)this.userContactInfo).hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.specificUsage);
    }
}

