/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.quality;

import java.util.Collection;
import java.util.Date;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.Result;
import org.opengis.util.InternationalString;

public class ElementImpl
extends MetadataEntity
implements Element {
    private static final long serialVersionUID = -3542504624077298894L;
    private Collection namesOfMeasure;
    private Identifier measureIdentification;
    private InternationalString measureDescription;
    private EvaluationMethodType evaluationMethodType;
    private InternationalString evaluationMethodDescription;
    private Citation evaluationProcedure;
    private long date1;
    private long date2;
    private Result result;

    public ElementImpl() {
    }

    public ElementImpl(Result result) {
        this.setResult(result);
    }

    public synchronized Collection getNamesOfMeasure() {
        this.namesOfMeasure = this.nonNullCollection(this.namesOfMeasure, InternationalString.class);
        return this.namesOfMeasure;
    }

    public synchronized void setNamesOfMeasure(Collection newValues) {
        this.namesOfMeasure = this.copyCollection(newValues, this.namesOfMeasure, InternationalString.class);
    }

    public Identifier getMeasureIdentification() {
        return this.measureIdentification;
    }

    public synchronized void setMeasureIdentification(Identifier newValue) {
        this.checkWritePermission();
        this.measureIdentification = newValue;
    }

    public InternationalString getMeasureDescription() {
        return this.measureDescription;
    }

    public synchronized void setMeasureDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.measureDescription = newValue;
    }

    public EvaluationMethodType getEvaluationMethodType() {
        return this.evaluationMethodType;
    }

    public synchronized void setEvaluationMethodType(EvaluationMethodType newValue) {
        this.checkWritePermission();
        this.evaluationMethodType = newValue;
    }

    public InternationalString getEvaluationMethodDescription() {
        return this.evaluationMethodDescription;
    }

    public synchronized void setEvaluationMethodDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.evaluationMethodDescription = newValue;
    }

    public Citation getEvaluationProcedure() {
        return this.evaluationProcedure;
    }

    public synchronized void setEvaluationProcedure(Citation newValue) {
        this.checkWritePermission();
        this.evaluationProcedure = newValue;
    }

    public synchronized Date[] getDate() {
        if (this.date1 == Long.MIN_VALUE) {
            return null;
        }
        if (this.date2 == Long.MIN_VALUE) {
            return new Date[]{new Date(this.date1)};
        }
        return new Date[]{new Date(this.date1), new Date(this.date2)};
    }

    public synchronized void setDate(Date[] newValue) {
        this.checkWritePermission();
        this.date2 = Long.MIN_VALUE;
        this.date1 = Long.MIN_VALUE;
        if (newValue != null) {
            switch (newValue.length) {
                default: {
                    throw new IllegalArgumentException();
                }
                case 2: {
                    this.date2 = newValue[1].getTime();
                }
                case 1: {
                    this.date1 = newValue[0].getTime();
                }
                case 0: 
            }
        }
    }

    public Result getResult() {
        return this.result;
    }

    public synchronized void setResult(Result newValue) {
        this.checkWritePermission();
        this.result = newValue;
    }

    protected void freeze() {
        super.freeze();
        this.namesOfMeasure = (Collection)ElementImpl.unmodifiable(this.namesOfMeasure);
        this.measureIdentification = (Identifier)ElementImpl.unmodifiable(this.measureIdentification);
        this.measureDescription = (InternationalString)ElementImpl.unmodifiable(this.measureDescription);
        this.evaluationMethodDescription = (InternationalString)ElementImpl.unmodifiable(this.evaluationMethodDescription);
        this.evaluationProcedure = (Citation)ElementImpl.unmodifiable(this.evaluationProcedure);
        this.result = (Result)ElementImpl.unmodifiable(this.result);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            ElementImpl that = (ElementImpl)object;
            return Utilities.equals(this.namesOfMeasure, that.namesOfMeasure) && Utilities.equals(this.measureIdentification, that.measureIdentification) && Utilities.equals(this.measureDescription, that.measureDescription) && Utilities.equals(this.evaluationMethodType, that.evaluationMethodType) && Utilities.equals(this.evaluationMethodDescription, that.evaluationMethodDescription) && Utilities.equals(this.evaluationProcedure, that.evaluationProcedure) && Utilities.equals(this.result, that.result) && this.date1 == that.date1 && this.date2 == that.date2;
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 984720178;
        if (this.namesOfMeasure != null) {
            code ^= ((Object)this.namesOfMeasure).hashCode();
        }
        if (this.measureIdentification != null) {
            code ^= this.measureIdentification.hashCode();
        }
        return code;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuffer buffer = new StringBuffer();
        if (this.measureDescription != null) {
            buffer.append("Measure: ");
            buffer.append((CharSequence)this.measureDescription);
            buffer.append(lineSeparator);
        }
        buffer.append(this.result);
        return buffer.toString();
    }
}

