/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.geotools.io.TableWriter;
import org.geotools.measure.Angle;
import org.geotools.measure.AngleFormat;
import org.geotools.resources.Arguments;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;
import org.geotools.resources.gcs.Resources;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;

public class ParameterWriter
extends FilterWriter {
    private Locale locale = Locale.getDefault();
    private transient NumberFormat numberFormat;
    private transient DateFormat dateFormat;
    private transient AngleFormat angleFormat;

    public ParameterWriter() {
        this(Arguments.getWriter(System.out));
    }

    public ParameterWriter(Writer out) {
        super(out);
    }

    public static void print(OperationMethod operation) {
        ParameterWriter writer = new ParameterWriter();
        try {
            writer.format(operation);
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static void print(ParameterDescriptorGroup descriptor) {
        ParameterWriter writer = new ParameterWriter();
        try {
            writer.format(descriptor);
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static void print(ParameterValueGroup values) {
        ParameterWriter writer = new ParameterWriter();
        try {
            writer.format(values);
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(OperationMethod operation) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.format(operation.getName().getCode(), operation.getParameters(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(ParameterDescriptorGroup descriptor) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.format(descriptor.getName().getCode(), descriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(ParameterValueGroup values) throws IOException {
        ParameterDescriptorGroup descriptor = (ParameterDescriptorGroup)values.getDescriptor();
        Object object = this.lock;
        synchronized (object) {
            this.format(descriptor.getName().getCode(), descriptor, values);
        }
    }

    private void format(String name, ParameterDescriptorGroup group, ParameterValueGroup values) throws IOException {
        Object element;
        String lineSeparator = System.getProperty("line.separator", "\n");
        this.out.write(32);
        this.out.write(name);
        this.out.write(lineSeparator);
        Collection alias = group.getAlias();
        if (alias != null) {
            boolean first = true;
            Iterator i = alias.iterator();
            while (i.hasNext()) {
                GenericName a = (GenericName)i.next();
                this.out.write(first ? " alias " : "       ");
                this.out.write(a.toInternationalString().toString(this.locale));
                this.out.write(lineSeparator);
                first = false;
            }
        }
        Resources resources = Resources.getResources(this.locale);
        TableWriter table = new TableWriter(this.out, " \u2502 ");
        table.setMultiLinesCells(true);
        table.writeHorizontalSeparator();
        table.write(resources.getString(20));
        table.nextColumn();
        table.write(resources.getString(2));
        table.nextColumn();
        table.write("Minimum");
        table.nextColumn();
        table.write("Maximum");
        table.nextColumn();
        table.write(resources.getString(values == null ? 8 : 32));
        table.nextColumn();
        table.write("Units");
        table.nextLine();
        table.nextLine('\u2550');
        ArrayList deferredGroups = null;
        Object[] array1 = new Object[1];
        List elements = values != null ? values.values() : group.descriptors();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            GeneralParameterDescriptor generalDescriptor;
            GeneralParameterValue generalValue;
            element = it.next();
            if (values != null) {
                generalValue = (GeneralParameterValue)element;
                generalDescriptor = generalValue.getDescriptor();
            } else {
                generalValue = null;
                generalDescriptor = (GeneralParameterDescriptor)element;
            }
            if (generalDescriptor instanceof ParameterDescriptorGroup) {
                if (deferredGroups == null) {
                    deferredGroups = new ArrayList();
                }
                deferredGroups.add(element);
                continue;
            }
            Identifier identifier = generalDescriptor.getName();
            table.write(identifier.getCode());
            alias = generalDescriptor.getAlias();
            if (alias != null) {
                Iterator i = alias.iterator();
                while (i.hasNext()) {
                    GenericName a = (GenericName)i.next();
                    if (identifier.equals(a)) continue;
                    table.write(lineSeparator);
                    table.write(a.asLocalName().toInternationalString().toString(this.locale));
                }
            }
            table.nextColumn();
            if (generalDescriptor instanceof ParameterDescriptor) {
                Object array;
                ParameterDescriptor descriptor = (ParameterDescriptor)generalDescriptor;
                table.write(Utilities.getShortName(descriptor.getValueClass()));
                table.nextColumn();
                table.setAlignment(2);
                Object value = descriptor.getMinimumValue();
                if (value != null) {
                    table.write(this.formatValue(value));
                }
                table.nextColumn();
                value = descriptor.getMaximumValue();
                if (value != null) {
                    table.write(this.formatValue(value));
                }
                table.nextColumn();
                value = generalValue != null ? ((ParameterValue)generalValue).getValue() : descriptor.getDefaultValue();
                if (value != null && value.getClass().isArray()) {
                    array = value;
                } else {
                    array = array1;
                    array1[0] = value;
                }
                int length = Array.getLength(array);
                for (int i = 0; i < length; ++i) {
                    value = Array.get(array, i);
                    if (value == null) continue;
                    if (i != 0) {
                        table.write(lineSeparator);
                    }
                    table.write(this.formatValue(value));
                }
                table.nextColumn();
                table.setAlignment(0);
                value = descriptor.getUnit();
                if (value != null) {
                    table.write(value.toString());
                }
            }
            table.writeHorizontalSeparator();
        }
        table.flush();
        if (deferredGroups != null) {
            it = deferredGroups.iterator();
            while (it.hasNext()) {
                ParameterDescriptorGroup descriptor;
                ParameterValueGroup value;
                element = it.next();
                if (element instanceof ParameterValueGroup) {
                    value = (ParameterValueGroup)element;
                    descriptor = (ParameterDescriptorGroup)value.getDescriptor();
                } else {
                    value = null;
                    descriptor = (ParameterDescriptorGroup)element;
                }
                this.out.write(lineSeparator);
                this.format(name + '/' + descriptor.getName().getCode(), descriptor, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void summary(Collection parameters, Set scopes) throws IOException {
        Object alias;
        LinkedHashMap<Object, Integer> titles = new LinkedHashMap<Object, Integer>();
        ArrayList<Object[]> names = new ArrayList<Object[]>();
        Locale locale = this.locale;
        titles.put(null, new Integer(0));
        Iterator it = parameters.iterator();
        while (it.hasNext()) {
            IdentifiedObject element = (IdentifiedObject)it.next();
            Collection aliases = element.getAlias();
            Object[] elementNames = new String[titles.size()];
            elementNames[0] = element.getName().getCode();
            if (aliases != null) {
                int count = 0;
                Iterator i = aliases.iterator();
                while (i.hasNext()) {
                    int index;
                    Object title;
                    alias = (GenericName)i.next();
                    GenericName scope = alias.getScope();
                    LocalName name = alias.asLocalName();
                    if (scope != null) {
                        if (scopes != null && !scopes.contains(scope.toString())) continue;
                        title = scope.toInternationalString().toString(locale);
                    } else {
                        title = new Integer(count++);
                    }
                    Integer position = (Integer)titles.get(title);
                    if (position == null) {
                        position = new Integer(titles.size());
                        titles.put(title, position);
                    }
                    if ((index = position.intValue()) >= elementNames.length) {
                        elementNames = (String[])XArray.resize(elementNames, index + 1);
                    }
                    String oldName = elementNames[index];
                    String newName = name.toInternationalString().toString(locale);
                    if (oldName != null && oldName.length() <= newName.length()) continue;
                    elementNames[index] = newName;
                }
            }
            names.add(elementNames);
        }
        boolean[] hide = new boolean[titles.size()];
        int column = hide.length;
        block5: while (--column >= 1) {
            Iterator it2 = names.iterator();
            while (it2.hasNext()) {
                String name;
                String[] alias2 = (String[])it2.next();
                if (alias2.length <= column || (name = alias2[column]) == null || name.equals(alias2[0])) continue;
                continue block5;
            }
            hide[column] = true;
        }
        column = 0;
        Object object = this.lock;
        synchronized (object) {
            TableWriter table = new TableWriter(this.out, " \u2502 ");
            table.setMultiLinesCells(true);
            table.writeHorizontalSeparator();
            Iterator<Object> it3 = titles.keySet().iterator();
            while (it3.hasNext()) {
                Object element = it3.next();
                if (hide[column++]) continue;
                String title = element == null ? "Identifier" : (element instanceof String ? (String)element : "Alias " + element);
                table.write(title);
                table.nextColumn();
            }
            table.writeHorizontalSeparator();
            it3 = names.iterator();
            while (it3.hasNext()) {
                String[] aliases = (String[])it3.next();
                for (column = 0; column < aliases.length; ++column) {
                    if (hide[column]) continue;
                    alias = aliases[column];
                    if (alias != null) {
                        table.write((String)alias);
                    }
                    table.nextColumn();
                }
                table.nextLine();
            }
            table.writeHorizontalSeparator();
            table.flush();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale locale) {
        Object object = this.lock;
        synchronized (object) {
            this.locale = locale;
            this.numberFormat = null;
            this.dateFormat = null;
            this.angleFormat = null;
        }
    }

    protected String formatValue(Object value) {
        if (value instanceof Number) {
            if (this.numberFormat == null) {
                this.numberFormat = NumberFormat.getNumberInstance(this.locale);
            }
            return this.numberFormat.format(value);
        }
        if (value instanceof Date) {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getDateInstance(2, this.locale);
            }
            return this.dateFormat.format(value);
        }
        if (value instanceof Angle) {
            if (this.angleFormat == null) {
                this.angleFormat = AngleFormat.getInstance(this.locale);
            }
            return this.angleFormat.format(value);
        }
        return String.valueOf(value);
    }
}

