/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.factory.Hints;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;

public class CRS {
    private static final CoordinateOperationFactory distanceOperationFactory;
    static /* synthetic */ Class class$org$opengis$referencing$crs$CoordinateReferenceSystem;

    public static MathTransform transform(CoordinateReferenceSystem from, CoordinateReferenceSystem to, boolean lenientTransforms) throws FactoryException {
        if (lenientTransforms) {
            return FactoryFinder.getCoordinateOperationFactory(new Hints(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE)).createOperation(from, to).getMathTransform();
        }
        return CRS.transform(from, to);
    }

    public static MathTransform transform(final CoordinateReferenceSystem from, final CoordinateReferenceSystem to) throws FactoryException {
        List list = CRS.visit(new OperationVisitor(){

            public Object factory(CoordinateOperationFactory factory) throws FactoryException {
                CoordinateOperation operation = factory.createOperation(from, to);
                return operation.getMathTransform();
            }
        });
        return list.isEmpty() ? null : (MathTransform)list.get(0);
    }

    private static List visit(OperationVisitor visitor) throws FactoryException {
        Throwable trouble = null;
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator i = FactoryFinder.getCoordinateOperationFactories().iterator();
        while (i.hasNext()) {
            CoordinateOperationFactory factory = (CoordinateOperationFactory)i.next();
            try {
                Object value = visitor.factory(factory);
                if (value == null) continue;
                list.add(value);
            }
            catch (Throwable t) {
                trouble = t;
            }
        }
        if (list.isEmpty() && trouble != null) {
            if (trouble instanceof FactoryException) {
                throw (FactoryException)trouble;
            }
            if (trouble instanceof Exception) {
                throw new FactoryException((Exception)trouble);
            }
            throw new FactoryException("Trouble encountered while visiting CoordianteOpperationFactory", trouble);
        }
        return list;
    }

    public static Set getSupportedCodes(String AUTHORITY) {
        TreeSet result = new TreeSet();
        Iterator i = FactoryFinder.getCRSAuthorityFactories().iterator();
        while (i.hasNext()) {
            CRSAuthorityFactory factory = (CRSAuthorityFactory)i.next();
            try {
                Citation authority = factory.getAuthority();
                if (!authority.getIdentifiers().contains(AUTHORITY)) continue;
                Set s = factory.getAuthorityCodes(class$org$opengis$referencing$crs$CoordinateReferenceSystem == null ? CRS.class$("org.opengis.referencing.crs.CoordinateReferenceSystem") : class$org$opengis$referencing$crs$CoordinateReferenceSystem);
                result.addAll(s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static CoordinateReferenceSystem decode(String code) throws NoSuchAuthorityCodeException {
        int split = code.indexOf(58);
        if (split == -1) {
            throw new NoSuchAuthorityCodeException("No authority was defined - did you forget 'AUTHORITY:NUMBER'?", "unknown", code);
        }
        String AUTHORITY = code.substring(0, split).trim().toUpperCase();
        Throwable trouble = null;
        Iterator i = FactoryFinder.getCRSAuthorityFactories().iterator();
        while (i.hasNext()) {
            CRSAuthorityFactory factory = (CRSAuthorityFactory)i.next();
            try {
                CoordinateReferenceSystem crs;
                Citation authority = factory.getAuthority();
                if (!authority.getIdentifiers().contains(AUTHORITY) || (crs = (CoordinateReferenceSystem)factory.createObject(code.toUpperCase())) == null) continue;
                return crs;
            }
            catch (FactoryException e) {
                trouble = e;
            }
            catch (Throwable e) {
                trouble = e;
            }
        }
        if (trouble instanceof NoSuchAuthorityCodeException) {
            throw (NoSuchAuthorityCodeException)trouble;
        }
        NoSuchAuthorityCodeException notFound = new NoSuchAuthorityCodeException("Unabled to locate code", "not found", code);
        if (trouble != null) {
            notFound.initCause(trouble);
        }
        throw notFound;
    }

    public static double distance(Coordinate p1, Coordinate p2, CoordinateReferenceSystem crs) throws Exception {
        GeodeticCalculator gc = new GeodeticCalculator();
        double[] cs = new double[4];
        double[] csLatLong = new double[4];
        cs[0] = p1.x;
        cs[1] = p1.y;
        cs[2] = p2.x;
        cs[3] = p2.y;
        MathTransform transform = distanceOperationFactory.createOperation(crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84).getMathTransform();
        transform.transform(cs, 0, csLatLong, 0, 2);
        gc.setAnchorPoint(csLatLong[0], csLatLong[1]);
        gc.setDestinationPoint(csLatLong[2], csLatLong[3]);
        return gc.getOrthodromicDistance();
    }

    static {
        Hints hints = new Hints(Hints.LENIENT_DATUM_SHIFT, Boolean.TRUE);
        distanceOperationFactory = FactoryFinder.getCoordinateOperationFactory(hints);
    }

    public static interface OperationVisitor {
        public Object factory(CoordinateOperationFactory var1) throws FactoryException;
    }
}

