/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.geotools.util.GrowableInternationalString;
import org.geotools.util.LocalName;
import org.geotools.util.ScopedName;
import org.geotools.util.WeakValueHashMap;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class NamedIdentifier
implements Identifier,
GenericName,
Serializable {
    private static final long serialVersionUID = 8474731565582774497L;
    public static final String CODE_PROPERTY = "code";
    public static final String AUTHORITY_PROPERTY = "authority";
    public static final String VERSION_PROPERTY = "version";
    private static final String REMARKS_KEY = "remarks";
    public static final String REMARKS_PROPERTY = "remarks";
    private static Map SCOPES;
    private final String code;
    private final Citation authority;
    private final String version;
    private final InternationalString remarks;
    private GenericName name;

    public NamedIdentifier(Map properties) throws IllegalArgumentException {
        this(properties, true);
    }

    public NamedIdentifier(Citation authority, InternationalString code) {
        this(authority, code.toString(Locale.US));
        this.name = NamedIdentifier.getName(authority, (CharSequence)code);
    }

    public NamedIdentifier(Citation authority, String code) {
        this(authority, code, null);
    }

    public NamedIdentifier(Citation authority, String code, String version) {
        this(NamedIdentifier.toMap(authority, code, version));
    }

    private static Map toMap(Citation authority, String code, String version) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        if (authority != null) {
            properties.put(AUTHORITY_PROPERTY, authority);
        }
        if (code != null) {
            properties.put(CODE_PROPERTY, code);
        }
        if (version != null) {
            properties.put(VERSION_PROPERTY, version);
        }
        return properties;
    }

    NamedIdentifier(Map properties, boolean standalone) throws IllegalArgumentException {
        NamedIdentifier.ensureNonNull("properties", properties);
        Object code = null;
        Object version = null;
        Object authority = null;
        Object remarks = null;
        GrowableInternationalString growable = null;
        String key = null;
        Object value = null;
        Iterator it = properties.entrySet().iterator();
        block9: while (it.hasNext()) {
            Map.Entry entry = it.next();
            key = ((String)entry.getKey()).trim().toLowerCase();
            value = entry.getValue();
            switch (key.hashCode()) {
                case 3373707: {
                    if (standalone || !key.equals("name")) break;
                    code = value;
                    continue block9;
                }
                case 3059181: {
                    if (!key.equals(CODE_PROPERTY)) break;
                    code = value;
                    continue block9;
                }
                case 351608024: {
                    if (!key.equals(VERSION_PROPERTY)) break;
                    version = value;
                    continue block9;
                }
                case 1475610435: {
                    if (!key.equals(AUTHORITY_PROPERTY)) break;
                    if (value instanceof String) {
                        value = new CitationImpl(value.toString());
                    }
                    authority = value;
                    continue block9;
                }
                case 1091415283: {
                    if (!standalone || !key.equals("remarks") || !(value instanceof InternationalString)) break;
                    remarks = value;
                    continue block9;
                }
            }
            if (!standalone || !(value instanceof String)) continue;
            if (growable == null) {
                growable = remarks instanceof GrowableInternationalString ? (GrowableInternationalString)remarks : new GrowableInternationalString();
            }
            growable.add("remarks", key, value.toString());
        }
        if (growable != null && !growable.getLocales().isEmpty()) {
            if (remarks == null) {
                remarks = growable;
            } else {
                Logger.getLogger("org.geotools.referencing").warning(Resources.format(128));
            }
        }
        try {
            key = CODE_PROPERTY;
            value = code;
            this.code = (String)value;
            key = VERSION_PROPERTY;
            value = version;
            this.version = (String)value;
            key = AUTHORITY_PROPERTY;
            value = authority;
            this.authority = (Citation)value;
            key = "remarks";
            value = remarks;
            this.remarks = (InternationalString)value;
        }
        catch (ClassCastException exception) {
            InvalidParameterValueException e = new InvalidParameterValueException(Resources.format(82, key, value), key, value);
            e.initCause((Throwable)exception);
            throw e;
        }
        NamedIdentifier.ensureNonNull(CODE_PROPERTY, code);
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new InvalidParameterValueException(Resources.format(115, name), name, object);
        }
    }

    public String getCode() {
        return this.code;
    }

    public Citation getAuthority() {
        return this.authority;
    }

    public String getVersion() {
        return this.version;
    }

    public InternationalString getRemarks() {
        return this.remarks;
    }

    private GenericName getName() {
        if (this.name == null) {
            this.name = NamedIdentifier.getName(this.authority, this.code);
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GenericName getName(Citation authority, CharSequence code) {
        GenericName scope;
        if (authority == null) {
            return new LocalName(code);
        }
        InternationalString title = authority.getTitle();
        int length = title.length();
        Collection alt = authority.getAlternateTitles();
        if (alt != null) {
            Iterator it = alt.iterator();
            while (it.hasNext()) {
                InternationalString candidate = (InternationalString)it.next();
                int candidateLength = candidate.length();
                if (candidateLength <= 0 || candidateLength >= length) continue;
                title = candidate;
                length = candidateLength;
            }
        }
        Class clazz = NamedIdentifier.class;
        synchronized (clazz) {
            if (SCOPES == null) {
                SCOPES = new WeakValueHashMap();
            }
            if ((scope = (GenericName)SCOPES.get(title)) == null) {
                scope = new LocalName((CharSequence)title);
                SCOPES.put(title, scope);
            }
        }
        return new ScopedName(scope, code);
    }

    public GenericName getScope() {
        return this.getName().getScope();
    }

    public org.opengis.util.ScopedName asScopedName() {
        return this.getName().asScopedName();
    }

    public org.opengis.util.LocalName asLocalName() {
        return this.getName().asLocalName();
    }

    public List getParsedNames() {
        return this.getName().getParsedNames();
    }

    public InternationalString toInternationalString() {
        return this.getName().toInternationalString();
    }

    public String toString() {
        return this.getName().toString();
    }

    public int compareTo(Object object) {
        return this.getName().compareTo(object);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            NamedIdentifier that = (NamedIdentifier)object;
            return Utilities.equals(this.code, that.code) && Utilities.equals(this.version, that.version) && Utilities.equals(this.authority, that.authority) && Utilities.equals(this.remarks, that.remarks);
        }
        return false;
    }

    public int hashCode() {
        int hash = 895086817;
        if (this.code != null) {
            hash ^= this.code.hashCode();
        }
        if (this.version != null) {
            hash = hash * 37 + this.version.hashCode();
        }
        return hash;
    }
}

