/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractCRS;
import org.geotools.referencing.cs.DefaultCompoundCS;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.cts.Resources;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;

public class DefaultCompoundCRS
extends AbstractCRS
implements CompoundCRS {
    private static final long serialVersionUID = -2656710314586929286L;
    private final List crs;

    public DefaultCompoundCRS(String name, CoordinateReferenceSystem head, CoordinateReferenceSystem tail) {
        this(name, new CoordinateReferenceSystem[]{head, tail});
    }

    public DefaultCompoundCRS(String name, CoordinateReferenceSystem head, CoordinateReferenceSystem middle, CoordinateReferenceSystem tail) {
        this(name, new CoordinateReferenceSystem[]{head, middle, tail});
    }

    public DefaultCompoundCRS(String name, CoordinateReferenceSystem[] crs) {
        this(Collections.singletonMap("name", name), crs);
    }

    public DefaultCompoundCRS(Map properties, CoordinateReferenceSystem[] crs) {
        super(properties, DefaultCompoundCRS.createCoordinateSystem(crs));
        DefaultCompoundCRS.ensureNonNull("crs", crs);
        crs = (CoordinateReferenceSystem[])crs.clone();
        for (int i = 0; i < crs.length; ++i) {
            DefaultCompoundCRS.ensureNonNull("crs", crs, i);
        }
        if (crs.length < 2) {
            throw new IllegalArgumentException(Resources.format(101, "crs[" + crs.length + ']'));
        }
        this.crs = Collections.unmodifiableList(Arrays.asList(crs));
    }

    private static CoordinateSystem createCoordinateSystem(CoordinateReferenceSystem[] crs) {
        if (crs == null) {
            return null;
        }
        CoordinateSystem[] cs = new CoordinateSystem[crs.length];
        for (int i = 0; i < crs.length; ++i) {
            cs[i] = crs[i].getCoordinateSystem();
        }
        return new DefaultCompoundCS(cs);
    }

    public List getCoordinateReferenceSystems() {
        return this.crs;
    }

    public SingleCRS[] getSingleCRS() {
        ArrayList singles = new ArrayList(this.crs.size());
        DefaultCompoundCRS.getSingleCRS(this.crs, singles);
        return singles.toArray(new SingleCRS[singles.size()]);
    }

    public static SingleCRS[] getSingleCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof DefaultCompoundCRS) {
            return ((DefaultCompoundCRS)crs).getSingleCRS();
        }
        if (crs instanceof CompoundCRS) {
            List elements = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            ArrayList singles = new ArrayList(elements.size());
            DefaultCompoundCRS.getSingleCRS(elements, singles);
            return singles.toArray(new SingleCRS[singles.size()]);
        }
        return new SingleCRS[]{(SingleCRS)crs};
    }

    private static void getSingleCRS(List crs, List singles) {
        Iterator it = crs.iterator();
        while (it.hasNext()) {
            CoordinateReferenceSystem candidate = (CoordinateReferenceSystem)it.next();
            if (candidate instanceof CompoundCRS) {
                DefaultCompoundCRS.getSingleCRS(((CompoundCRS)candidate).getCoordinateReferenceSystems(), singles);
                continue;
            }
            singles.add((SingleCRS)candidate);
        }
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultCompoundCRS that = (DefaultCompoundCRS)object;
            return DefaultCompoundCRS.equals(this.crs, that.crs, compareMetadata);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.crs).hashCode() ^ 0x73EE077A;
    }

    protected String formatWKT(Formatter formatter) {
        Iterator it = this.crs.iterator();
        while (it.hasNext()) {
            formatter.append((IdentifiedObject)((CoordinateReferenceSystem)it.next()));
        }
        return "COMPD_CS";
    }
}

