/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.units.Unit;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class DefaultProjectedCRS
extends AbstractDerivedCRS
implements ProjectedCRS {
    private static final long serialVersionUID = -4502680112031773028L;
    static /* synthetic */ Class class$java$lang$Number;

    public DefaultProjectedCRS(String name, OperationMethod method, GeographicCRS base, MathTransform baseToDerived, CartesianCS derivedCS) throws MismatchedDimensionException {
        this(Collections.singletonMap("name", name), method, base, baseToDerived, derivedCS);
    }

    public DefaultProjectedCRS(Map properties, OperationMethod method, GeographicCRS base, MathTransform baseToDerived, CartesianCS derivedCS) throws MismatchedDimensionException {
        super(properties, method, (CoordinateReferenceSystem)base, baseToDerived, (CoordinateSystem)derivedCS);
    }

    public DefaultProjectedCRS(Map properties, Conversion conversionFromBase, GeographicCRS base, MathTransform baseToDerived, CartesianCS derivedCS) throws MismatchedDimensionException {
        super(properties, conversionFromBase, (CoordinateReferenceSystem)base, baseToDerived, (CoordinateSystem)derivedCS);
    }

    public static Matrix createLinearConversion(ProjectedCRS sourceCRS, ProjectedCRS targetCRS, double errorTolerance) {
        if (!DefaultProjectedCRS.equals((IdentifiedObject)sourceCRS.getBaseCRS(), (IdentifiedObject)targetCRS.getBaseCRS(), false)) {
            return null;
        }
        Conversion sourceOp = sourceCRS.getConversionFromBase();
        Conversion targetOp = targetCRS.getConversionFromBase();
        if (!DefaultProjectedCRS.equals((IdentifiedObject)sourceOp.getMethod(), (IdentifiedObject)targetOp.getMethod(), false)) {
            return null;
        }
        ParameterValueGroup sourceGroup = sourceOp.getParameterValues();
        ParameterValueGroup targetGroup = targetOp.getParameterValues();
        if (sourceGroup == null || targetGroup == null) {
            return null;
        }
        List sourceParams = sourceGroup.values();
        List targetParams = targetGroup.values();
        GeneralParameterValue[] sourceArray = sourceParams.toArray(new GeneralParameterValue[sourceParams.size()]);
        double scaleX = 1.0;
        double scaleY = 1.0;
        double oldTX = 0.0;
        double oldTY = 0.0;
        double newTX = 0.0;
        double newTY = 0.0;
        Iterator it = targetParams.iterator();
        block0: while (it.hasNext()) {
            GeneralParameterValue targetParam = (GeneralParameterValue)it.next();
            GeneralParameterDescriptor descriptor = targetParam.getDescriptor();
            String name = descriptor.getName().getCode();
            for (int j = 0; j < sourceArray.length; ++j) {
                GeneralParameterValue sourceParam = sourceArray[j];
                if (sourceParam == null || !DefaultProjectedCRS.nameMatches((IdentifiedObject)sourceParam.getDescriptor(), name)) continue;
                if (sourceParam instanceof ParameterValue && targetParam instanceof ParameterValue) {
                    ParameterValue parameter = (ParameterValue)targetParam;
                    ParameterValue candidate = (ParameterValue)sourceParam;
                    if ((class$java$lang$Number == null ? DefaultProjectedCRS.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(((ParameterDescriptor)descriptor).getValueClass())) {
                        double sourceValue;
                        double targetValue;
                        Unit unit = parameter.getUnit();
                        if (unit != null) {
                            targetValue = parameter.doubleValue(unit);
                            sourceValue = candidate.doubleValue(unit);
                        } else {
                            targetValue = parameter.doubleValue();
                            sourceValue = candidate.doubleValue();
                        }
                        if (DefaultProjectedCRS.nameMatches((IdentifiedObject)descriptor, "scale_factor")) {
                            double scale = targetValue / sourceValue;
                            scaleX *= scale;
                            scaleY *= scale;
                        } else if (DefaultProjectedCRS.nameMatches((IdentifiedObject)descriptor, "semi_major")) {
                            scaleX *= targetValue / sourceValue;
                        } else if (DefaultProjectedCRS.nameMatches((IdentifiedObject)descriptor, "semi_minor")) {
                            scaleY *= targetValue / sourceValue;
                        } else if (DefaultProjectedCRS.nameMatches((IdentifiedObject)descriptor, "false_easting")) {
                            oldTX += sourceValue;
                            newTX += targetValue;
                        } else if (DefaultProjectedCRS.nameMatches((IdentifiedObject)descriptor, "false_northing")) {
                            oldTY += sourceValue;
                            newTY += targetValue;
                        } else {
                            double error = targetValue - sourceValue;
                            if (targetValue != 0.0) {
                                error /= targetValue;
                            }
                            if (!(Math.abs(error) <= errorTolerance)) {
                                return null;
                            }
                        }
                    } else if (!Utilities.equals(parameter.getValue(), candidate.getValue())) {
                        return null;
                    }
                } else if (!Utilities.equals(targetParam, sourceParam)) {
                    return null;
                }
                sourceArray[j] = null;
                continue block0;
            }
            return null;
        }
        for (int i = 0; i < sourceArray.length; ++i) {
            if (sourceArray[i] == null) continue;
            return null;
        }
        if (!(Math.abs(scaleX - scaleY) <= errorTolerance)) {
            return null;
        }
        double scale = 0.5 * (scaleX + scaleY);
        CoordinateSystem sourceCS = sourceCRS.getCoordinateSystem();
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        Matrix matrix = AbstractCS.swapAndScaleAxis(sourceCS, targetCS);
        int sourceDim = sourceCS.getDimension();
        int targetDim = targetCS.getDimension();
        for (int j = 0; j < targetDim; ++j) {
            double newT;
            double oldT;
            AxisDirection axis = targetCS.getAxis(j).getDirection();
            if (AxisDirection.EAST.equals(axis)) {
                oldT = oldTX;
                newT = newTX;
            } else if (AxisDirection.WEST.equals(axis)) {
                oldT = -oldTX;
                newT = -newTX;
            } else if (AxisDirection.NORTH.equals(axis)) {
                oldT = oldTY;
                newT = newTY;
            } else {
                if (!AxisDirection.SOUTH.equals(axis)) continue;
                oldT = -oldTY;
                newT = -newTY;
            }
            for (int i = 0; i <= sourceDim; ++i) {
                matrix.setElement(j, i, matrix.getElement(j, i) * scale);
            }
            matrix.setElement(j, sourceDim, matrix.getElement(j, sourceDim) + (newT - oldT * scale));
        }
        return matrix;
    }

    public int hashCode() {
        return 0x59214E9C ^ super.hashCode();
    }

    protected String formatWKT(Formatter formatter) {
        Unit unit = this.getUnit();
        Unit linearUnit = formatter.getLinearUnit();
        Unit angularUnit = formatter.getAngularUnit();
        formatter.setLinearUnit(unit);
        formatter.setAngularUnit(DefaultGeographicCRS.getAngularUnit(this.baseCRS.getCoordinateSystem()));
        formatter.append((IdentifiedObject)this.baseCRS);
        formatter.append((IdentifiedObject)this.conversionFromBase.getMethod());
        List parameters = this.conversionFromBase.getParameterValues().values();
        Iterator it = parameters.iterator();
        while (it.hasNext()) {
            GeneralParameterValue param = (GeneralParameterValue)it.next();
            if (DefaultProjectedCRS.nameMatches((IdentifiedObject)param.getDescriptor(), "semi_major") || DefaultProjectedCRS.nameMatches((IdentifiedObject)param.getDescriptor(), "semi_minor")) continue;
            formatter.append(param);
        }
        formatter.append(unit);
        int dimension = this.coordinateSystem.getDimension();
        for (int i = 0; i < dimension; ++i) {
            formatter.append((IdentifiedObject)this.coordinateSystem.getAxis(i));
        }
        if (unit == null) {
            formatter.setInvalidWKT();
        }
        formatter.setAngularUnit(angularUnit);
        formatter.setLinearUnit(linearUnit);
        return "PROJCS";
    }
}

